/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.canon.model;

import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.symphonyoss.s2.canon.model.AbstractParameter;
import org.symphonyoss.s2.canon.model.ModelElement;
import org.symphonyoss.s2.canon.parser.ParserContext;
import org.symphonyoss.s2.canon.parser.error.ParserError;
import org.symphonyoss.s2.canon.runtime.http.ParameterLocation;

public class Parameter
extends AbstractParameter {
    private static Logger log_ = LoggerFactory.getLogger(Parameter.class);
    private final String scopedName_;
    private final ParameterLocation location_;

    private Parameter(ModelElement parent, ParserContext parserContext, String name, String scopedName, ParameterLocation location) {
        super(parent, parserContext, "Parameter", name);
        this.scopedName_ = scopedName;
        this.location_ = location;
    }

    @Nullable
    public static Parameter create(ModelElement methodSchema, ParserContext paramContext) {
        String in;
        ParameterLocation parameterIn = null;
        switch (in = paramContext.getText("in")) {
            case "query": {
                parameterIn = ParameterLocation.Query;
                break;
            }
            case "header": {
                parameterIn = ParameterLocation.Header;
                break;
            }
            case "path": {
                parameterIn = ParameterLocation.Path;
                break;
            }
            case "cookie": {
                parameterIn = ParameterLocation.Cookie;
                break;
            }
            default: {
                paramContext.raise(new ParserError("Invalid value for in \"%s\"", in));
                return null;
            }
        }
        String name = paramContext.getName();
        if (name == null) {
            paramContext.raise(new ParserError("Name is required", new Object[0]));
            name = "UnNamed";
        }
        return new Parameter(methodSchema, paramContext, name, methodSchema.getCamelCapitalizedName() + methodSchema.getParent().getCamelCapitalizedName() + name.substring(0, 1).toUpperCase() + name.substring(1) + parameterIn + "Parameter", parameterIn);
    }

    public ParameterLocation getLocation() {
        return this.location_;
    }

    @Override
    public String toString() {
        return super.toString() + ", localtion=" + this.location_;
    }
}

