/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.canon.model;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import org.symphonyoss.s2.canon.model.IPathNameConstructor;
import org.symphonyoss.s2.canon.model.ModelElement;
import org.symphonyoss.s2.canon.parser.GenerationException;

public class PathNameConstructor
implements IPathNameConstructor {
    @Override
    public String constructFile(Map<String, Object> dataModel, String language, String templateName, ModelElement modelElement) throws GenerationException {
        return this.constructFile(language, null, templateName, modelElement, modelElement.getName());
    }

    public String constructFile(String language, Object directoryPath, String templateName, ModelElement modelElement, String modelElementName) throws GenerationException {
        int underscoreIndex = templateName.indexOf(95);
        int dollarIndex = templateName.indexOf(36);
        if (underscoreIndex == -1 && dollarIndex == -1) {
            return null;
        }
        StringBuilder s = null;
        if (language != null) {
            s = new StringBuilder();
            s.append(language);
        }
        if (directoryPath != null) {
            if (s == null) {
                s = new StringBuilder();
            } else {
                s.append(File.separatorChar);
            }
            s.append(directoryPath);
        }
        if (s == null) {
            s = new StringBuilder();
        } else {
            s.append(File.separatorChar);
        }
        if (dollarIndex != -1) {
            char[] chars;
            ArrayList<String> varNameList = new ArrayList<String>();
            StringBuilder varName = null;
            boolean firstVarName = true;
            boolean inDollar = false;
            block12: for (char c : chars = templateName.endsWith(".ftl") ? templateName.substring(0, templateName.length() - 4).toCharArray() : templateName.toCharArray()) {
                if (inDollar) {
                    switch (c) {
                        case '{': {
                            varName = new StringBuilder();
                            varNameList.clear();
                            firstVarName = true;
                            break;
                        }
                        default: {
                            s.append('$');
                            s.append(c);
                        }
                    }
                    inDollar = false;
                    continue;
                }
                if (varName != null) {
                    switch (c) {
                        case '}': {
                            varNameList.add(varName.toString());
                            varName = null;
                            firstVarName = true;
                            Object value = modelElement;
                            for (String v : varNameList) {
                                String name = "get" + v;
                                try {
                                    Method getter = modelElement.getClass().getMethod(name, new Class[0]);
                                    value = getter.invoke(value, new Object[0]);
                                }
                                catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                                    throw new GenerationException("Unknown variable \"" + name + "\"", e);
                                }
                            }
                            s.append(value);
                            break;
                        }
                        case '.': {
                            varNameList.add(varName.toString());
                            varName = new StringBuilder();
                            firstVarName = true;
                            break;
                        }
                        default: {
                            if (firstVarName) {
                                varName.append(Character.toUpperCase(c));
                                firstVarName = false;
                                break;
                            }
                            varName.append(c);
                            break;
                        }
                    }
                    continue;
                }
                switch (c) {
                    case '$': {
                        inDollar = true;
                        continue block12;
                    }
                    default: {
                        s.append(c);
                    }
                }
            }
        } else {
            int len = templateName.endsWith(".ftl") ? templateName.length() - 4 : templateName.length();
            int i = 0;
            while (i < underscoreIndex) {
                s.append(templateName.charAt(i++));
            }
            ++i;
            s.append(modelElementName);
            while (i < len) {
                s.append(templateName.charAt(i++));
            }
        }
        return s.toString();
    }
}

