/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.canon.model;

import java.net.URI;
import java.net.URISyntaxException;
import org.symphonyoss.s2.canon.model.Model;
import org.symphonyoss.s2.canon.model.ModelElement;
import org.symphonyoss.s2.canon.parser.ParserContext;
import org.symphonyoss.s2.canon.parser.error.ParserError;

public class Reference<T extends ModelElement>
extends ModelElement {
    private final Class<T> type_;
    private URI uri_;
    private String path_;
    private String fragment_;
    private URI baseUri_;
    private T referent_;

    public Reference(ModelElement parent, ParserContext context, Class<T> type) {
        super(parent, context, "Ref");
        this.type_ = type;
        try {
            String text = context.getJsonNode().asText();
            if (text == null || text.length() == 0) {
                context.raise(new ParserError("Empty URI", new Object[0]));
            }
            this.uri_ = new URI(text);
            this.path_ = this.uri_.getPath();
            this.fragment_ = this.uri_.getFragment();
            String s = this.uri_.toString();
            int i = s.indexOf(35);
            if (i == -1) {
                this.baseUri_ = this.uri_;
            } else {
                try {
                    this.baseUri_ = new URI(s.substring(0, i));
                }
                catch (URISyntaxException e) {
                    context.raise(new ParserError("Invalid base URI \"%s\"", s.substring(0, i)));
                }
            }
        }
        catch (URISyntaxException e) {
            context.raise(new ParserError("Invalid URI \"%s\"", context.getJsonNode().asText()));
        }
    }

    @Override
    public void resolve() {
        super.resolve();
        if (this.path_ != null && this.fragment_ != null) {
            ModelElement referent;
            if (this.path_.length() > 0) {
                Model model = this.getContext().getRootParserContext().getModel(this.baseUri_);
                referent = this.fragment_.startsWith("/") ? model.getByPath(this.fragment_.split("/"), 1) : model.getByPath(this.fragment_.split("/"), 0);
            } else {
                ModelElement modelElement = referent = this.fragment_.startsWith("/") ? this.getModel().getByPath(this.fragment_.split("/"), 1) : this.getByPath(this.fragment_.split("/"), 0);
            }
            if (referent == null) {
                this.getContext().raise(new ParserError("Referenced %s \"%s\" not found.", this.type_.getName(), this.uri_));
            } else if (this.type_.isInstance(referent)) {
                this.referent_ = (ModelElement)this.type_.cast(referent);
            } else {
                this.getContext().raise(new ParserError("Referenced object \"%s\" is not a %s but a %s", this.type_.getName(), this.uri_, referent.getClass().getName()));
            }
        }
    }

    public T getReferent() {
        return this.referent_;
    }

    @Override
    public ModelElement getReference() {
        return this.referent_;
    }

    public URI getUri() {
        return this.uri_;
    }

    public String getPath() {
        return this.path_;
    }

    public String getFragment() {
        return this.fragment_;
    }

    public URI getBaseUri() {
        return this.baseUri_;
    }
}

