/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.canon.model;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.symphonyoss.s2.canon.model.AbstractSchema;
import org.symphonyoss.s2.canon.model.AllOfSchema;
import org.symphonyoss.s2.canon.model.ArraySchema;
import org.symphonyoss.s2.canon.model.Component;
import org.symphonyoss.s2.canon.model.Components;
import org.symphonyoss.s2.canon.model.Field;
import org.symphonyoss.s2.canon.model.ModelElement;
import org.symphonyoss.s2.canon.model.ObjectSchema;
import org.symphonyoss.s2.canon.model.OneOfSchema;
import org.symphonyoss.s2.canon.model.ReferenceOrSchema;
import org.symphonyoss.s2.canon.model.Type;
import org.symphonyoss.s2.canon.model.TypeDef;
import org.symphonyoss.s2.canon.parser.ParserContext;
import org.symphonyoss.s2.canon.parser.error.UnexpectedTypeError;

public class Schemas
extends ModelElement {
    private static final String SCHEMAS = "Schemas";
    private static Logger log_ = LoggerFactory.getLogger(Schemas.class);
    private Map<String, ReferenceOrSchema> schemaMap_ = new HashMap<String, ReferenceOrSchema>();

    public Schemas(Components parent, ParserContext parserContext) {
        super(parent, parserContext, SCHEMAS, parent.getModel().getName());
        for (ParserContext schema : parserContext) {
            log_.debug("Found schema \"" + schema.getName() + "\" at " + schema.getPath());
            AbstractSchema objectSchema = Field.createSchema(this, schema);
            if (schema.getName().startsWith("#")) {
                log_.debug("Comment ignored.");
                continue;
            }
            if (objectSchema instanceof Type) {
                objectSchema = new TypeDef((ModelElement)this, schema, objectSchema, objectSchema.getName());
            } else if (objectSchema instanceof ArraySchema) {
                objectSchema = new Component(this, schema, objectSchema, "Array", objectSchema.getName());
            } else if (objectSchema instanceof ObjectSchema) {
                objectSchema = new Component(this, schema, objectSchema, "Object", objectSchema.getName());
            } else if (objectSchema instanceof OneOfSchema) {
                objectSchema = new Component(this, schema, objectSchema, "OneOf", objectSchema.getName());
            } else if (objectSchema instanceof AllOfSchema) {
                objectSchema = new Component(this, schema, objectSchema, "AllOf", objectSchema.getName());
            }
            if (objectSchema instanceof ReferenceOrSchema) {
                this.schemaMap_.put(schema.getPath(), (ReferenceOrSchema)objectSchema);
                this.add(schema.getName(), objectSchema);
                continue;
            }
            schema.raise(new UnexpectedTypeError(ReferenceOrSchema.class, (Object)objectSchema));
        }
    }

    @Override
    protected void getReferencedTypes(Set<AbstractSchema> result) {
        result.addAll(this.schemaMap_.values());
    }

    @Override
    public String toString() {
        return SCHEMAS;
    }
}

