/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.canon.model;

import org.symphonyoss.s2.canon.model.AbstractSchema;
import org.symphonyoss.s2.canon.model.EnumSchema;
import org.symphonyoss.s2.canon.model.ModelElement;
import org.symphonyoss.s2.canon.model.Schema;
import org.symphonyoss.s2.canon.model.ValueMap;
import org.symphonyoss.s2.canon.parser.ParserContext;
import org.symphonyoss.s2.canon.parser.error.ParserError;

public class Field
extends AbstractSchema {
    private final boolean required_;
    private final AbstractSchema type_;

    public Field(ModelElement parent, ParserContext context, AbstractSchema type, boolean required, String name) {
        super(parent, context, "Field", name);
        this.required_ = required;
        if (type == null) {
            throw new NullPointerException("Type is null");
        }
        this.type_ = type;
        this.add(this.type_);
    }

    @Override
    public Schema getBaseSchema() {
        return this.type_.getBaseSchema();
    }

    @Override
    public ModelElement getComponent() {
        return this.type_.getComponent();
    }

    @Override
    public Schema getElementSchema() {
        return this.type_.getElementSchema();
    }

    @Override
    public ModelElement getElementComponent() {
        return this.type_.getElementComponent();
    }

    @Override
    public boolean getIsArraySchema() {
        return this.type_.getIsArraySchema();
    }

    @Override
    public boolean getIsObjectSchema() {
        return this.type_.getIsObjectSchema();
    }

    @Override
    public boolean isRequired() {
        return this.required_;
    }

    public AbstractSchema getType() {
        return this.type_;
    }

    @Override
    public EnumSchema getEnum() {
        return this.type_.getEnum();
    }

    @Override
    public boolean getHasSet() {
        return this.type_.getHasSet();
    }

    @Override
    public boolean getHasList() {
        return this.type_.getHasList();
    }

    @Override
    public boolean getHasByteString() {
        return this.type_.getHasByteString();
    }

    @Override
    public boolean getIsTypeDef() {
        return this.type_.getIsTypeDef();
    }

    @Override
    public boolean getIsComponent() {
        return this.type_.getIsComponent();
    }

    @Override
    public boolean getIsObjectType() {
        return this.type_.getIsObjectType();
    }

    @Override
    public boolean getCanFailValidation() {
        return this.required_ || this.type_.getCanFailValidation();
    }

    @Override
    public void validate() {
        super.validate();
        if (this.type_ == null) {
            this.getContext().raise(new ParserError("Field type must be specified", new Object[0]));
        }
    }

    public static AbstractSchema create(ModelElement parent, ParserContext context, boolean required) {
        if (context.getName().startsWith("#")) {
            return null;
        }
        AbstractSchema schema = AbstractSchema.createSchema(parent, context);
        return new Field(parent, context, schema, required, context.getName());
    }

    @Override
    public String toString() {
        return this.toString(new ValueMap<String, String>().insert("type", this.type_.getElementType(), "UNDEFINED").insert("required", (String)((Object)Boolean.valueOf(this.required_)), null));
    }
}

