/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.canon.model;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.symphonyoss.s2.canon.model.Parameter;
import org.symphonyoss.s2.canon.model.ParameterContainer;
import org.symphonyoss.s2.canon.model.PathItem;
import org.symphonyoss.s2.canon.model.Payload;
import org.symphonyoss.s2.canon.model.Response;
import org.symphonyoss.s2.canon.parser.ParserContext;
import org.symphonyoss.s2.canon.parser.error.ParserError;
import org.symphonyoss.s2.canon.runtime.http.ParameterLocation;

public class Operation
extends ParameterContainer {
    private static Logger log_ = LoggerFactory.getLogger(Operation.class);
    private final PathItem pathItem_;
    private Response response_;
    private Payload payload_;
    private List<Parameter> pathParameters_ = new ArrayList<Parameter>();

    public Operation(PathItem parent, ParserContext parserContext) {
        super(parent, parserContext, "Operation", parserContext.getName());
        ParserContext responseContext;
        this.pathItem_ = parent;
        ParserContext payloadContext = parserContext.get("payload");
        if (payloadContext != null) {
            this.payload_ = new Payload(this, payloadContext);
            this.add(this.payload_);
        }
        if ((responseContext = parserContext.get("response")) != null) {
            this.response_ = new Response(this, responseContext);
            this.add(this.response_);
        }
    }

    public Response getResponse() {
        return this.response_;
    }

    public Payload getPayload() {
        return this.payload_;
    }

    @Override
    public void validate() {
        super.validate();
        for (String paramName : this.pathItem_.getPathParamNames()) {
            Parameter param = this.getParameter(ParameterLocation.Path, paramName);
            if (param == null) {
                this.getContext().raise(new ParserError("Path parameter \"%s\" is not defined", paramName));
                continue;
            }
            this.pathParameters_.add(param);
        }
    }

    public boolean getIsStreamable() {
        if (this.payload_ == null && this.response_ == null) {
            return false;
        }
        if (this.payload_ != null && !this.payload_.getIsMultiple()) {
            return false;
        }
        return this.response_ == null || this.response_.getIsMultiple();
    }

    public PathItem getPathItem() {
        return this.pathItem_;
    }

    public List<Parameter> getPathParameters() {
        return this.pathParameters_;
    }

    @Override
    public String toString() {
        return super.toString() + ", path=" + this.pathItem_.getPath();
    }
}

