/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.canon.parser;

import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Version;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.symphonyoss.s2.canon.parser.GenerationException;
import org.symphonyoss.s2.canon.parser.MultiDirTemplateLoader;
import org.symphonyoss.s2.common.fault.TransactionFault;

public class GenerationContext {
    private MultiDirTemplateLoader templateLoader_ = new MultiDirTemplateLoader();
    private File targetDir_;
    private File proformaDir_;
    private File copyDir_;
    private Set<String> languages_ = new HashSet<String>();
    private Configuration config_;
    private Map<String, Object> dataModel_ = new HashMap<String, Object>();

    public GenerationContext(String targetDirName, String proformaDirName, String copyDirName) throws GenerationException {
        this(new File(targetDirName), proformaDirName == null ? new File(targetDirName) : new File(proformaDirName), copyDirName == null ? null : new File(copyDirName));
    }

    public GenerationContext(File targetDir, File proformaDir, File copyDir) throws GenerationException {
        this.validateDir(targetDir);
        if (proformaDir != null) {
            this.validateDir(proformaDir);
        }
        if (copyDir != null) {
            this.validateDir(copyDir);
        }
        this.targetDir_ = targetDir;
        this.proformaDir_ = proformaDir;
        this.copyDir_ = copyDir;
        this.config_ = new Configuration(new Version(2, 3, 25));
        this.config_.setTemplateLoader((TemplateLoader)this.templateLoader_);
        this.config_.setDefaultEncoding("UTF-8");
        this.config_.setLocale(Locale.US);
    }

    public Object put(String key, Object value) {
        return this.dataModel_.put(key, value);
    }

    public Map<String, Object> getDataModel() {
        return this.dataModel_;
    }

    private void validateDir(File targetDir) throws GenerationException {
        if (!targetDir.exists()) {
            if (!targetDir.mkdirs()) {
                throw new GenerationException("Target dir \"" + targetDir.getAbsolutePath() + "\" does not exist and cannot be created.");
            }
        } else {
            if (!targetDir.isDirectory()) {
                throw new GenerationException("Target dir \"" + targetDir.getAbsolutePath() + "\" is not a directory.");
            }
            if (!targetDir.canWrite()) {
                throw new GenerationException("Target dir \"" + targetDir.getAbsolutePath() + "\" is not writable.");
            }
        }
    }

    public void addTemplateDirectory(File dir) {
        this.addTemplateDirectory(dir, this.templateLoader_);
    }

    public void addTemplateDirectory(File dir, MultiDirTemplateLoader templateLoader) {
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("\"" + dir.getAbsolutePath() + "\" is not a directory");
        }
        try {
            templateLoader.addTemplateDirectory(dir);
        }
        catch (IOException e) {
            throw new TransactionFault("Failed to add \"" + dir.getAbsolutePath() + "\"", (Throwable)e);
        }
        this.addLanguages(dir, "template");
        this.addLanguages(dir, "proforma");
    }

    private void addLanguages(File dir, String proforma) {
        File[] languages;
        File dd = new File(dir, proforma);
        if (dd.isDirectory() && (languages = dd.listFiles()) != null) {
            for (File f : languages) {
                if (!f.isDirectory()) continue;
                this.languages_.add(f.getName());
            }
        }
    }

    public Configuration getFreemarkerConfig() {
        return this.config_;
    }

    public Set<String> getTemplatesFor(String templateOrProforma, String language, String type) {
        return this.templateLoader_.getTemplatesFor(templateOrProforma, language, type);
    }

    public Set<String> getLanguages() {
        return this.languages_;
    }

    public File getTargetDir() {
        return this.targetDir_;
    }

    public File getProformaDir() {
        return this.proformaDir_;
    }

    public File getCopyDir() {
        return this.copyDir_;
    }
}

