/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.canon.parser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.main.JsonSchema;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.symphonyoss.s2.canon.model.Model;
import org.symphonyoss.s2.canon.parser.ParserContext;
import org.symphonyoss.s2.canon.parser.ParsingException;
import org.symphonyoss.s2.canon.parser.RootParserContext;
import org.symphonyoss.s2.canon.parser.SchemaValidationException;

public class Parser {
    private static Logger log_ = LoggerFactory.getLogger(Parser.class);
    private JsonSchema schema_ = this.getJsonSchemaFromClasspath("canon-schema-v1.json");

    public Model parse(RootParserContext rootParserContext) throws ParsingException {
        try {
            rootParserContext.prologue();
            ObjectMapper mapper = new ObjectMapper().configure(JsonParser.Feature.ALLOW_COMMENTS, true).configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true).configure(JsonParser.Feature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER, true);
            JsonNode rootNode = mapper.readTree(rootParserContext.getReader());
            if (rootNode == null) {
                throw new ParsingException("Null input");
            }
            ProcessingReport report = this.schema_.validate(rootNode);
            if (!report.isSuccess()) {
                rootParserContext.error("Schema validation FAILED:", new Object[0]);
                log_.error(report.toString());
                throw new SchemaValidationException(report.toString());
            }
            log_.info("Schema validation passed.");
            Model model = new Model(new ParserContext(rootParserContext, rootNode));
            rootParserContext.setModel(model);
            rootParserContext.epilogue("Parsing");
            return model;
        }
        catch (ProcessingException | IOException e) {
            throw new ParsingException(e);
        }
    }

    public JsonSchema getJsonSchemaFromClasspath(String name) throws ParsingException {
        JsonSchemaFactory factory = JsonSchemaFactory.byDefault();
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(name);
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode jsonNode = mapper.readTree(is);
            return factory.getJsonSchema(jsonNode);
        }
        catch (ProcessingException | IOException e) {
            throw new ParsingException(e);
        }
    }
}

