/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.canon.parser;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Iterator;
import java.util.Map;
import org.symphonyoss.s2.canon.parser.BaseParserContext;
import org.symphonyoss.s2.canon.parser.RootParserContext;
import org.symphonyoss.s2.canon.parser.error.UnexpectedTypeError;

public class ParserContext
extends BaseParserContext
implements Iterable<ParserContext> {
    private final ParserContext parent_;
    private final JsonNode jsonNode_;
    private final String name_;
    private final boolean anonymousInner_;

    ParserContext(RootParserContext rootParserContext, JsonNode rootNode) {
        super(rootParserContext, "#");
        this.parent_ = this;
        this.jsonNode_ = rootNode;
        this.name_ = rootParserContext.getInputSourceName();
        this.anonymousInner_ = false;
    }

    public ParserContext(ParserContext parent, String name, JsonNode jsonNode, boolean anonymousInner) {
        super(parent.getRootParserContext(), parent.getPath() + "/" + name);
        this.parent_ = parent;
        this.jsonNode_ = jsonNode;
        this.name_ = name;
        this.anonymousInner_ = anonymousInner;
    }

    public ParserContext getParent() {
        return this.parent_;
    }

    public ParserContext get(String name) {
        if (this.jsonNode_.get(name) == null) {
            return null;
        }
        return new ParserContext(this, name, this.jsonNode_.get(name), false);
    }

    public JsonNode getJsonNode() {
        return this.jsonNode_;
    }

    public String getName() {
        return this.name_;
    }

    public boolean isAnonymousInner() {
        return this.anonymousInner_;
    }

    public boolean isEmpty() {
        return this.jsonNode_.size() == 0;
    }

    public int size() {
        return this.jsonNode_.size();
    }

    public final boolean isArray() {
        return this.jsonNode_.isArray();
    }

    public final boolean isObject() {
        return this.jsonNode_.isObject();
    }

    public final boolean isTextual() {
        return this.jsonNode_.isTextual();
    }

    public final boolean isBoolean() {
        return this.jsonNode_.isBoolean();
    }

    public boolean asBoolean() {
        return this.jsonNode_.asBoolean();
    }

    public String asText() {
        return this.jsonNode_.asText();
    }

    @Override
    public Iterator<ParserContext> iterator() {
        if (this.jsonNode_.isObject()) {
            return new FieldIterator();
        }
        if (this.jsonNode_.isArray()) {
            return new ArrayIterator();
        }
        throw new RuntimeException("Unknown JsonNode type " + this.jsonNode_);
    }

    public String getTextNode(String fieldName) {
        JsonNode node = this.jsonNode_.get(fieldName);
        if (node != null) {
            if (!node.isTextual()) {
                this.raise(new UnexpectedTypeError(fieldName, String.class, node));
            }
            return node.asText();
        }
        return "";
    }

    public Boolean getBooleanNode(String fieldName) {
        JsonNode node = this.jsonNode_.get(fieldName);
        if (node != null) {
            if (!node.isBoolean()) {
                this.raise(new UnexpectedTypeError(fieldName, Boolean.class, node));
            }
            return node.asBoolean();
        }
        return null;
    }

    public Boolean getBooleanNode(String fieldName, Boolean defaultValue) {
        JsonNode node = this.jsonNode_.get(fieldName);
        if (node != null) {
            if (!node.isBoolean()) {
                this.raise(new UnexpectedTypeError(fieldName, Boolean.class, node));
            }
            return node.asBoolean(defaultValue.booleanValue());
        }
        return defaultValue;
    }

    public Long getLongNode(String fieldName) {
        JsonNode node = this.jsonNode_.get(fieldName);
        if (node != null) {
            if (!node.isNumber()) {
                this.raise(new UnexpectedTypeError(fieldName, Long.class, node));
            }
            return node.asLong();
        }
        return null;
    }

    public long getLongNode(String fieldName, long defaultValue) {
        JsonNode node = this.jsonNode_.get(fieldName);
        if (node != null) {
            if (!node.isNumber()) {
                this.raise(new UnexpectedTypeError(fieldName, Long.class, node));
            }
            return node.asLong(defaultValue);
        }
        return defaultValue;
    }

    public Double getDoubleNode(String fieldName) {
        JsonNode node = this.jsonNode_.get(fieldName);
        if (node != null) {
            if (!node.isNumber()) {
                this.raise(new UnexpectedTypeError(fieldName, Double.class, node));
            }
            return node.asDouble();
        }
        return null;
    }

    public double getDoubleNode(String fieldName, double defaultValue) {
        JsonNode node = this.jsonNode_.get(fieldName);
        if (node != null) {
            if (!node.isNumber()) {
                this.raise(new UnexpectedTypeError(fieldName, Double.class, node));
            }
            return node.asDouble(defaultValue);
        }
        return defaultValue;
    }

    public String toString() {
        return "ParserContext(" + this.jsonNode_ + ")";
    }

    public String getText(String name) {
        JsonNode jsonNode = this.getJsonNode().get(name);
        if (jsonNode == null) {
            return null;
        }
        return jsonNode.asText();
    }

    public String getText(String name, String defaultValue) {
        JsonNode jsonNode = this.getJsonNode().get(name);
        if (jsonNode == null) {
            return defaultValue;
        }
        return jsonNode.asText();
    }

    public class ArrayIterator
    implements Iterator<ParserContext> {
        Iterator<JsonNode> it_;
        int index_;

        public ArrayIterator() {
            this.it_ = ParserContext.this.jsonNode_.elements();
            this.index_ = 0;
        }

        @Override
        public boolean hasNext() {
            return this.it_.hasNext();
        }

        @Override
        public ParserContext next() {
            return new ParserContext(ParserContext.this, String.format("$%d", this.index_++), this.it_.next(), true);
        }
    }

    public class FieldIterator
    implements Iterator<ParserContext> {
        Iterator<Map.Entry<String, JsonNode>> it_;

        public FieldIterator() {
            this.it_ = ParserContext.this.jsonNode_.fields();
        }

        @Override
        public boolean hasNext() {
            return this.it_.hasNext();
        }

        @Override
        public ParserContext next() {
            Map.Entry<String, JsonNode> e = this.it_.next();
            return new ParserContext(ParserContext.this, e.getKey(), e.getValue(), false);
        }
    }
}

