/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.canon.model;

import java.util.List;
import java.util.Map;
import org.symphonyoss.s2.canon.model.AllOfSchema;
import org.symphonyoss.s2.canon.model.ModelElement;
import org.symphonyoss.s2.canon.model.ObjectSchema;
import org.symphonyoss.s2.canon.model.OneOfSchema;
import org.symphonyoss.s2.canon.model.ReferenceSchema;
import org.symphonyoss.s2.canon.model.Schema;
import org.symphonyoss.s2.canon.model.SchemaBuilder;
import org.symphonyoss.s2.canon.model.Type;
import org.symphonyoss.s2.canon.model.ValueMap;
import org.symphonyoss.s2.canon.parser.GenerationContext;
import org.symphonyoss.s2.canon.parser.GenerationException;
import org.symphonyoss.s2.canon.parser.ParserContext;

public abstract class AbstractSchema
extends ModelElement {
    public AbstractSchema(ModelElement parent, ParserContext context, String type, String name) {
        super(parent, context, type, name);
    }

    @Override
    protected void generateChildren(GenerationContext generationContext, Map<String, Object> dataModel) throws GenerationException {
    }

    @Override
    public abstract Schema getBaseSchema();

    @Override
    public abstract Schema getElementSchema();

    @Override
    public abstract boolean getIsArraySchema();

    @Override
    public abstract boolean getIsObjectSchema();

    public boolean isRequired() {
        return false;
    }

    public boolean getIsAnonymousInnerClass() {
        ParserContext context = this.getContext();
        if (context == null) {
            return false;
        }
        return context.isAnonymousInner();
    }

    protected AbstractSchema createSchema(ParserContext context) {
        return AbstractSchema.createSchema(this, context);
    }

    static AbstractSchema createSchema(ModelElement parent, ParserContext context) {
        return AbstractSchema.createSchema(parent, context, context.getName());
    }

    static AbstractSchema createSchema(ModelElement parent, ParserContext context, String name) {
        ParserContext properties;
        SchemaBuilder builder = new SchemaBuilder(parent, context);
        builder.build("allOf", (m, c, n) -> new AllOfSchema(m, c, n, name));
        builder.build("oneOf", (m, c, n) -> new OneOfSchema(m, c, n, name));
        builder.build("$ref", (m, c, n) -> new ReferenceSchema(m, c, n, name));
        builder.build("type", (m, c, n) -> Type.create(m, c, n, name));
        if (builder.getResult() == null && (properties = context.get("properties")) != null) {
            return new ObjectSchema(parent, context, name);
        }
        return builder.getResult();
    }

    @Override
    public String toString() {
        return this.getElementType() + '(' + this.getName() + ')';
    }

    protected String toString(StringBuffer details) {
        return this.getElementType() + '(' + this.getName() + details + ')';
    }

    protected String toString(List<?> children) {
        StringBuffer s = new StringBuffer();
        for (Object c : children) {
            s.append(',');
            s.append(c);
        }
        return this.toString(s);
    }

    protected String toString(ValueMap<String, Object> children) {
        StringBuffer s = new StringBuffer();
        for (ValueMap.Entry<String, Object> entry : children) {
            s.append(',');
            s.append(entry.getKey());
            s.append('=');
            s.append(entry.getValue());
        }
        return this.toString(s);
    }
}

