/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.canon.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.symphonyoss.s2.canon.model.AbstractSchema;
import org.symphonyoss.s2.canon.model.AllOfSchema;
import org.symphonyoss.s2.canon.model.Field;
import org.symphonyoss.s2.canon.model.ModelElement;
import org.symphonyoss.s2.canon.model.ReferenceSchema;
import org.symphonyoss.s2.canon.model.Schema;
import org.symphonyoss.s2.canon.model.Schemas;
import org.symphonyoss.s2.canon.parser.BaseParserContext;
import org.symphonyoss.s2.canon.parser.GenerationContext;
import org.symphonyoss.s2.canon.parser.GenerationException;
import org.symphonyoss.s2.canon.parser.ParserContext;
import org.symphonyoss.s2.canon.parser.error.ParserError;
import org.symphonyoss.s2.canon.parser.error.ParserInfo;

public class ObjectSchema
extends Schema {
    private Set<String> requiredButUndefinedSet_ = new HashSet<String>();
    private List<ModelElement> fields_ = new ArrayList<ModelElement>();
    private boolean generateFacade_;
    private boolean generateBuilderFacade_;
    private ReferenceSchema superSchema_;

    public ObjectSchema(ModelElement parent, ParserContext context, String name) {
        super(parent, context, "ObjectSchema", name);
        if (parent instanceof Schemas || parent instanceof AllOfSchema) {
            ParserContext properties;
            ParserContext requiredFields = context.get("required");
            if (requiredFields != null) {
                for (Object child : requiredFields) {
                    String fieldName = ((ParserContext)child).getJsonNode().asText();
                    if (this.requiredButUndefinedSet_.contains(fieldName)) {
                        ((BaseParserContext)child).raise(new ParserError("Duplication of required field \"%s\"", fieldName));
                        continue;
                    }
                    this.requiredButUndefinedSet_.add(fieldName);
                }
            }
            if ((properties = context.get("properties")) == null) {
                context.raise(new ParserError("Elements with \"type\": \"object\" require \"properties\":", new Object[0]));
            } else {
                for (ParserContext child : properties) {
                    String fieldName;
                    boolean required;
                    AbstractSchema field = Field.create(this, child, required = this.requiredButUndefinedSet_.remove(fieldName = child.getName()));
                    if (field == null) continue;
                    this.add(field);
                    this.fields_.add(field);
                }
            }
            for (String requiredField : this.requiredButUndefinedSet_) {
                context.raise(new ParserError("Required field \"%s\" is not defined!", requiredField));
            }
            this.generateFacade_ = context.getBooleanNode("facade", false);
            this.generateBuilderFacade_ = context.getBooleanNode("builderFacade", false);
            ParserContext extendsContext = context.get("extends");
            if (extendsContext != null) {
                this.superSchema_ = new ReferenceSchema((ModelElement)this, extendsContext, extendsContext, "extends");
                this.add(this.superSchema_);
            }
        } else {
            context.raise(new ParserError("Nested in-line object definitions are not supported, move this to Components/Schemas amd refer to is with $ref", new Object[0]));
        }
    }

    @Override
    public void validate() {
        Schema referent;
        super.validate();
        if (this.superSchema_ != null && this.superSchema_.isResolved() && !((referent = this.superSchema_.getReference().getBaseSchema()) instanceof ObjectSchema)) {
            this.getContext().raise(new ParserError("Extends must refer to an Object Schema not a %s", referent.getClass().getSimpleName()));
        }
    }

    public ReferenceSchema getSuperSchema() {
        return this.superSchema_;
    }

    @Override
    public List<ModelElement> getFields() {
        return this.fields_;
    }

    @Override
    public Schema getElementSchema() {
        return this;
    }

    @Override
    public ModelElement getElementComponent() {
        return this;
    }

    @Override
    public boolean getIsArraySchema() {
        return false;
    }

    @Override
    public boolean getIsObjectSchema() {
        return true;
    }

    @Override
    public boolean getHasSet() {
        for (ModelElement child : this.getChildren()) {
            if (!child.getHasSet()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean getHasList() {
        for (ModelElement child : this.getChildren()) {
            if (!child.getHasList()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean getHasCollections() {
        for (ModelElement child : this.getChildren()) {
            if (!child.getHasSet() && !child.getHasList()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean getHasByteString() {
        for (ModelElement child : this.getChildren()) {
            if (!child.getHasByteString()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean getIsObjectType() {
        return true;
    }

    @Override
    public boolean getIsGenerateFacade() {
        return this.generateFacade_;
    }

    @Override
    public boolean getIsGenerateBuilderFacade() {
        return this.generateBuilderFacade_;
    }

    @Override
    public boolean getCanFailValidation() {
        for (ModelElement child : this.getChildren()) {
            if (!child.getCanFailValidation()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void getReferencedTypes(Set<AbstractSchema> result) {
        super.getReferencedTypes(result);
        for (ModelElement child : this.getChildren()) {
            child.getReferencedTypes(result);
        }
    }

    @Override
    protected void getSchemas(Set<AbstractSchema> result) {
        super.getSchemas(result);
        result.add(this);
    }

    @Override
    public void generate(GenerationContext generationContext, Map<String, Object> dataModel) throws GenerationException {
        if (this.getParent() instanceof AllOfSchema) {
            this.getContext().raise(new ParserInfo("ObjectSchema ignored for generation (parent is %s for %s)", this.getParent().getClass(), this.getName()));
        } else {
            this.getContext().raise(new ParserInfo("ObjectSchema parent is Schemas for %s", this.getName()));
            super.generate(generationContext, dataModel);
        }
    }
}

