/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.canon.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.symphonyoss.s2.canon.model.AbstractSchema;
import org.symphonyoss.s2.canon.model.ModelElement;
import org.symphonyoss.s2.canon.model.Parameter;
import org.symphonyoss.s2.canon.model.Reference;
import org.symphonyoss.s2.canon.parser.ParserContext;
import org.symphonyoss.s2.canon.parser.error.ParserError;
import org.symphonyoss.s2.canon.runtime.http.ParameterLocation;

public class ParameterContainer
extends ModelElement {
    private static Logger log_ = LoggerFactory.getLogger(ParameterContainer.class);
    private boolean resolved_;
    private boolean resolving_;
    private List<Parameter> parameters_ = new ArrayList<Parameter>();
    private List<Parameter> nonPathParameters_ = new ArrayList<Parameter>();
    private Map<String, Parameter> parameterMap_ = new HashMap<String, Parameter>();
    private Map<ParameterLocation, Map<String, Parameter>> locationMap_ = new HashMap<ParameterLocation, Map<String, Parameter>>();
    private List<Reference<ParameterContainer>> referenceList_ = new ArrayList<Reference<ParameterContainer>>();

    public ParameterContainer(ModelElement parent, ParserContext parserContext, String type, String name) {
        this(parent, parserContext, type, name, parserContext.get("parameters"), parserContext.get("parameterSets"));
    }

    public ParameterContainer(ModelElement parent, ParserContext objectContext, String type, String name, ParserContext parametersContext, ParserContext parameterSetsContext) {
        super(parent, objectContext, type, name);
        for (ParameterLocation loc : ParameterLocation.values()) {
            this.locationMap_.put(loc, new HashMap());
        }
        if (parametersContext != null) {
            if (parametersContext.isObject()) {
                for (ParserContext paramContext : parametersContext) {
                    Parameter param = Parameter.create(this, paramContext);
                    this.add(param);
                    this.addParameter(param);
                }
            } else {
                this.getContext().raise(new ParserError("The \"%s\" node must be an object.", parametersContext.getName()));
            }
        }
        if (parameterSetsContext != null) {
            if (parameterSetsContext.isArray()) {
                for (ParserContext refContext : parameterSetsContext) {
                    if (refContext.isTextual()) {
                        Reference<ParameterContainer> ref = new Reference<ParameterContainer>((ModelElement)this, refContext, ParameterContainer.class);
                        this.add(ref);
                        this.referenceList_.add(ref);
                        continue;
                    }
                    refContext.raise(new ParserError("Expected a string value", new Object[0]));
                }
            } else {
                this.getContext().raise(new ParserError("The \"%s\" node must be an array.", parameterSetsContext.getName()));
            }
        }
    }

    @Override
    public void validate() {
        super.validate();
        this.resolve(this);
    }

    private void resolve(ParameterContainer referer) {
        if (this.resolved_) {
            return;
        }
        if (this.resolving_) {
            this.getContext().raise(new ParserError("Circular depdendency detected via %s", referer.getContext().getPath()));
            return;
        }
        this.resolving_ = true;
        if (this.getParent() instanceof ParameterContainer) {
            ParameterContainer parent = (ParameterContainer)this.getParent();
            parent.resolve(this);
            for (Parameter p : parent.parameterMap_.values()) {
                this.addParameter(p);
            }
        }
        for (Reference<ParameterContainer> ref : this.referenceList_) {
            ParameterContainer container = ref.getReferent();
            if (container == null) {
                this.getContext().raise(new ParserError("Cannot find reference \"%s\"", ref.getUri()));
                continue;
            }
            container.resolve(this);
            for (Parameter param : container.parameterMap_.values()) {
                this.addParameter(param);
            }
        }
        this.resolved_ = true;
    }

    private void addParameter(Parameter param) {
        Parameter existing = this.parameterMap_.get(param.getName());
        if (existing != null) {
            this.getContext().raise(new ParserError("Duplicate parameter \"%s\" declared at %s", param.getName(), existing.getContext().getPath()));
        } else {
            this.parameters_.add(param);
            this.parameterMap_.put(param.getName(), param);
            this.locationMap_.get(param.getLocation()).put(param.getName(), param);
            if (param.getLocation() != ParameterLocation.Path) {
                this.nonPathParameters_.add(param);
            }
        }
    }

    public Parameter getParameter(String name) {
        return this.parameterMap_.get(name);
    }

    public Parameter getParameter(ParameterLocation location, String name) {
        return this.locationMap_.get(location).get(name);
    }

    public Map<String, Parameter> getParameterMap() {
        return this.parameterMap_;
    }

    public List<Parameter> getParameters() {
        return this.parameters_;
    }

    public List<Parameter> getNonPathParameters() {
        return this.nonPathParameters_;
    }

    public Map<ParameterLocation, Map<String, Parameter>> getLocationMap() {
        return this.locationMap_;
    }

    @Override
    public void getReferencedTypes(Set<AbstractSchema> result) {
        super.getReferencedTypes(result);
        for (Parameter param : this.parameterMap_.values()) {
            param.getReferencedTypes(result);
        }
    }
}

