/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.canon.model;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.symphonyoss.s2.canon.model.AbstractSchema;
import org.symphonyoss.s2.canon.model.Operation;
import org.symphonyoss.s2.canon.model.ParameterContainer;
import org.symphonyoss.s2.canon.model.Paths;
import org.symphonyoss.s2.canon.parser.ParserContext;
import org.symphonyoss.s2.canon.parser.error.ParserError;
import org.symphonyoss.s2.canon.runtime.http.HttpMethod;

public class PathItem
extends ParameterContainer {
    private static Logger log_ = LoggerFactory.getLogger(PathItem.class);
    private final Set<String> pathParamNames_;
    private final String bindPath_;
    private final String path_;
    private final String pathFormat_;
    private final List<Operation> operations_ = new ArrayList<Operation>();
    private final Set<HttpMethod> unsupportedOperations_ = EnumSet.allOf(HttpMethod.class);
    private List<String> partList_;

    public PathItem(Paths parent, ParserContext parserContext, String name, Set<String> pathParams, List<String> partList, String bindPath, String path, String pathFormat) {
        super(parent, parserContext, "Path", name);
        this.pathParamNames_ = pathParams;
        this.partList_ = partList;
        this.bindPath_ = bindPath;
        this.path_ = path;
        this.pathFormat_ = pathFormat;
        for (HttpMethod method : HttpMethod.values()) {
            this.addMethod(method, parserContext);
        }
    }

    public static PathItem create(Paths paths, ParserContext parserContext) {
        String part;
        HashSet<String> pathParams = new HashSet<String>();
        StringBuffer lineBuf = new StringBuffer();
        StringBuffer paramBuf = new StringBuffer();
        StringBuffer bindBuf = new StringBuffer();
        StringBuffer nameBuf = new StringBuffer();
        StringBuffer partBuf = new StringBuffer();
        StringBuffer formatBuf = new StringBuffer();
        boolean inParam = false;
        boolean inWord = false;
        boolean inBindPath = true;
        ArrayList<String> partList = new ArrayList<String>();
        char[] chars = parserContext.getName().toCharArray();
        if (chars[0] != '/') {
            parserContext.raise(new ParserError("Path must begin with a /", new Object[0]));
        }
        lineBuf.append('/');
        partBuf.append('/');
        formatBuf.append('/');
        for (int i = 1; i < chars.length; ++i) {
            char c = chars[i];
            switch (c) {
                case '{': {
                    inBindPath = false;
                    partList.add(partBuf.toString());
                    partBuf = new StringBuffer();
                    if (inParam) {
                        parserContext.raise(new ParserError("Unexpected { in path after \"%s\"", lineBuf));
                        break;
                    }
                    if (chars[i - 1] != '/') {
                        parserContext.raise(new ParserError("Unexpected { in path after \"%s\"", lineBuf));
                    }
                    inParam = true;
                    paramBuf = new StringBuffer();
                    formatBuf.append("%s");
                    break;
                }
                case '}': {
                    if (inParam) {
                        inParam = false;
                        if (pathParams.add(paramBuf.toString())) break;
                        parserContext.raise(new ParserError("Duplicate path parameter \"%s\"", paramBuf.toString()));
                        break;
                    }
                    parserContext.raise(new ParserError("Unexpected } in path after \"%s\"", lineBuf));
                    break;
                }
                case '/': {
                    if (!inWord) {
                        parserContext.raise(new ParserError("Double / detected in path.", Character.valueOf(c)));
                    }
                    inWord = false;
                    if (inParam) {
                        parserContext.raise(new ParserError("Character '%c' is not permitted in a parameter name.", Character.valueOf(c)));
                        break;
                    }
                    partBuf.append(c);
                    formatBuf.append(c);
                    break;
                }
                default: {
                    if (chars[i - 1] == '}') {
                        parserContext.raise(new ParserError("Unexpected characters in variable element after \"%s\"", lineBuf));
                    }
                    if (inParam) {
                        paramBuf.append(c);
                    } else {
                        partBuf.append(c);
                        formatBuf.append(c);
                    }
                    if (inWord) {
                        nameBuf.append(c);
                        break;
                    }
                    nameBuf.append(Character.toUpperCase(c));
                    inWord = true;
                }
            }
            lineBuf.append(c);
            if (!inBindPath) continue;
            bindBuf.append(c);
        }
        if (inParam) {
            parserContext.raise(new ParserError("Un-terminated parameter (missing }) in path after \"%s\"", lineBuf));
        }
        if (inWord && (part = partBuf.toString()).length() > 0) {
            partList.add(part);
        }
        if (pathParams.isEmpty()) {
            log_.debug("No path params");
        } else {
            for (String p : pathParams) {
                log_.debug("Path param \"{}\"", (Object)p);
            }
        }
        return new PathItem(paths, parserContext, nameBuf.toString(), pathParams, partList, bindBuf.toString(), lineBuf.toString(), formatBuf.toString());
    }

    private void addMethod(HttpMethod method, ParserContext parserContext) {
        ParserContext methodContext = parserContext.get(method.toString().toLowerCase());
        if (methodContext != null) {
            this.addMethod(method, new Operation(this, methodContext));
        }
    }

    private void addMethod(HttpMethod method, Operation operation) {
        this.add(operation);
        this.operations_.add(operation);
        this.unsupportedOperations_.remove(method);
    }

    public Set<String> getPathParamNames() {
        return this.pathParamNames_;
    }

    public String getBindPath() {
        return this.bindPath_;
    }

    public String getPath() {
        return this.path_;
    }

    public String getPathFormat() {
        return this.pathFormat_;
    }

    public String getAbsolutePath() {
        return this.getModel().getBasePath() + this.path_;
    }

    public List<Operation> getOperations() {
        return this.operations_;
    }

    public Set<HttpMethod> getUnsupportedOperations() {
        return this.unsupportedOperations_;
    }

    public List<String> getPartList() {
        return this.partList_;
    }

    public int getPathParamCnt() {
        return this.pathParamNames_.size();
    }

    @Override
    public void getReferencedTypes(Set<AbstractSchema> result) {
        super.getReferencedTypes(result);
        for (Operation op : this.operations_) {
            op.getReferencedTypes(result);
        }
    }
}

