/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.canon.parser;

import freemarker.cache.FileTemplateLoader;
import freemarker.cache.TemplateLoader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class MultiDirTemplateLoader
implements TemplateLoader {
    private Deque<TemplateLoader> templateLoaders_ = new LinkedList<TemplateLoader>();
    private Deque<File> templatedirs_ = new LinkedList<File>();
    private Map<Object, TemplateLoader> sourceMap_ = new HashMap<Object, TemplateLoader>();

    public Object findTemplateSource(String name) throws IOException {
        for (TemplateLoader loader : this.templateLoaders_) {
            Object templateSource = loader.findTemplateSource(name);
            if (templateSource == null) continue;
            this.sourceMap_.put(templateSource, loader);
            return templateSource;
        }
        return null;
    }

    public long getLastModified(Object templateSource) {
        TemplateLoader loader = this.sourceMap_.get(templateSource);
        if (loader == null) {
            return 0L;
        }
        return loader.getLastModified(templateSource);
    }

    public Reader getReader(Object templateSource, String encoding) throws IOException {
        TemplateLoader loader = this.sourceMap_.get(templateSource);
        if (loader == null) {
            throw new IOException("Unknown templateSource");
        }
        return loader.getReader(templateSource, encoding);
    }

    public void closeTemplateSource(Object templateSource) throws IOException {
        TemplateLoader loader = this.sourceMap_.remove(templateSource);
        if (loader == null) {
            throw new IOException("Unknown templateSource");
        }
        loader.closeTemplateSource(templateSource);
    }

    public void addTemplateDirectory(File dir) throws IOException {
        this.templateLoaders_.push((TemplateLoader)new FileTemplateLoader(dir));
        this.templatedirs_.push(dir);
    }

    public Set<String> getTemplatesFor(String templateOrProforma, String language, String type) {
        HashSet<String> result = new HashSet<String>();
        for (File dir : this.templatedirs_) {
            File f;
            String[] templates;
            File tORp = new File(dir, templateOrProforma);
            File l = new File(tORp, language);
            if (!l.isDirectory() || (templates = (f = new File(l, type)).list()) == null || templates.length <= 0) continue;
            for (String t : templates) {
                result.add(templateOrProforma + File.separatorChar + language + File.separatorChar + type + File.separatorChar + t);
            }
        }
        return result;
    }
}

