/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.canon.parser;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import javax.annotation.Nullable;
import org.symphonyoss.s2.canon.model.Model;
import org.symphonyoss.s2.canon.parser.BaseParserContext;
import org.symphonyoss.s2.canon.parser.ModelSetParserContext;
import org.symphonyoss.s2.canon.parser.ParserContext;
import org.symphonyoss.s2.canon.parser.ParsingException;
import org.symphonyoss.s2.canon.parser.error.ParserError;
import org.symphonyoss.s2.canon.parser.error.ParserInfo;
import org.symphonyoss.s2.canon.parser.error.ParserWarning;
import org.symphonyoss.s2.canon.parser.log.Logger;
import org.symphonyoss.s2.common.fault.CodingFault;
import org.symphonyoss.s2.common.fault.ProgramFault;

public class RootParserContext
extends BaseParserContext {
    private Logger log_;
    private final String inputSource_;
    private final String inputSourceName_;
    private final boolean referencedModel_;
    private Reader reader_;
    private int errorCnt_;
    private URL url_;
    private ModelSetParserContext modelSetParserContext_;
    private Model model_;

    public RootParserContext(ModelSetParserContext modelSetParserContext, URL url, boolean referencedModel) throws ParsingException {
        this(modelSetParserContext, url, RootParserContext.openStream(url), referencedModel);
    }

    private static Reader openStream(URL url) throws ParsingException {
        try {
            return new InputStreamReader(url.openStream());
        }
        catch (IOException e) {
            throw new ParsingException(e);
        }
    }

    public RootParserContext(ModelSetParserContext modelSetParserContext, URL baseUrl, Reader inputStream, boolean referencedModel) throws ParsingException {
        this.log_ = modelSetParserContext.getLogFactory().getLogger(RootParserContext.class);
        this.modelSetParserContext_ = modelSetParserContext;
        this.url_ = baseUrl;
        this.reader_ = inputStream;
        this.inputSource_ = this.url_.toString();
        this.referencedModel_ = referencedModel;
        String path = this.url_.getPath();
        if (path == null || path.length() == 0 || "/".equals(path)) {
            this.inputSourceName_ = this.url_.getHost();
        } else {
            int i = path.lastIndexOf(47);
            if (i != -1) {
                path = path.substring(i + 1);
            }
            this.inputSourceName_ = this.trim(path);
        }
    }

    private String trim(String path) {
        int l;
        if (path.length() > 5 && ".json".equalsIgnoreCase(path.substring(l = path.length() - 5))) {
            return path.substring(0, l);
        }
        if (path.length() > 3 && ".js".equalsIgnoreCase(path.substring(l = path.length() - 3))) {
            return path.substring(0, l);
        }
        return path;
    }

    public RootParserContext(File inputFile, Reader inputStream, boolean referencedModel) {
        this.reader_ = inputStream;
        this.inputSource_ = inputFile.getAbsolutePath();
        this.inputSourceName_ = inputFile.getName();
        this.referencedModel_ = referencedModel;
        try {
            this.url_ = inputFile.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new CodingFault((Throwable)e);
        }
    }

    public Model getModel() {
        return this.model_;
    }

    public void setModel(Model model) {
        this.model_ = model;
    }

    public boolean isReferencedModel() {
        return this.referencedModel_;
    }

    public URL getUrl() {
        return this.url_;
    }

    public Reader getReader() {
        return this.reader_;
    }

    public String getInputSource() {
        return this.inputSource_;
    }

    public String getInputSourceName() {
        return this.inputSourceName_;
    }

    @Override
    public void raise(ParserError error) {
        super.raise(error);
        this.log_.errorf("%n%nERROR: %s%nat %s%n%n", error.getMessage(), error.getLocation());
        ++this.errorCnt_;
    }

    @Override
    public void raise(ParserWarning warning) {
        super.raise(warning);
        this.log_.warnf("%s%nat %s%n%n", warning.getMessage(), warning.getLocation());
    }

    @Override
    public void raise(ParserInfo info) {
        super.raise(info);
        this.log_.infof("%s%nat %s%n%n", info.getMessage(), info.getLocation());
    }

    public void error(String format, Object ... args) {
        this.log_.errorf(format, args);
        ++this.errorCnt_;
    }

    public void epilogue(String action) {
        if (this.errorCnt_ == 0) {
            this.log_.infof("%s of %s completed OK.", action, this.getInputSource());
        } else {
            this.log_.errorf("%s of %s completed with %d errors.", action, this.getInputSource(), this.errorCnt_);
        }
    }

    public void prologue() {
        this.log_.infof("Parsing %s...", this.getInputSource());
    }

    @Nullable
    public RootParserContext addReferencedModel(URI uri, ParserContext context) throws ParsingException {
        try {
            URL url = uri.isAbsolute() ? uri.toURL() : new URL(this.url_, uri.toString());
            return this.modelSetParserContext_.addReferencedModel(url);
        }
        catch (IOException e) {
            context.raise(new ParserError("Invalid URI \"%s\" (%s)", uri, e.getMessage()));
            return null;
        }
    }

    public Model getModel(URI uri) {
        try {
            URL url = uri.isAbsolute() ? uri.toURL() : new URL(this.url_, uri.toString());
            return this.modelSetParserContext_.getModel(url);
        }
        catch (MalformedURLException e) {
            throw new ProgramFault((Throwable)e);
        }
    }

    public boolean hasErrors() {
        return this.errorCnt_ > 0;
    }
}

