/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.canon.model;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.symphonyoss.s2.canon.model.AbstractSchema;
import org.symphonyoss.s2.canon.model.Field;
import org.symphonyoss.s2.canon.model.ModelElement;
import org.symphonyoss.s2.canon.model.ReferenceOrSchema;
import org.symphonyoss.s2.canon.parser.ParserContext;
import org.symphonyoss.s2.canon.parser.error.ParserError;
import org.symphonyoss.s2.canon.parser.error.UnexpectedTypeError;

public abstract class AbstractParameter
extends ModelElement {
    private static Logger log_ = LoggerFactory.getLogger(AbstractParameter.class);
    private final boolean required_;
    private final ReferenceOrSchema schema_;

    protected AbstractParameter(ModelElement parent, ParserContext parserContext, String type, String name) {
        super(parent, parserContext, type, name);
        this.required_ = parserContext.get("required").getJsonNode().asBoolean();
        ParserContext schema = parserContext.get("schema");
        if (schema == null) {
            parserContext.raise(new ParserError("%s is required", "schema"));
            this.schema_ = null;
        } else {
            log_.debug("Found schema \"" + schema.getName() + "\" at " + schema.getPath());
            AbstractSchema objectSchema = Field.createSchema(this, schema, this.getName());
            if (objectSchema instanceof ReferenceOrSchema) {
                this.schema_ = (ReferenceOrSchema)objectSchema;
                this.add(this.schema_);
            } else {
                this.schema_ = null;
                schema.raise(new UnexpectedTypeError(ReferenceOrSchema.class, (Object)objectSchema));
            }
        }
    }

    public boolean getIsRequired() {
        return this.required_;
    }

    @Override
    public boolean getCanFailValidation() {
        return this.required_ || super.getCanFailValidation();
    }

    public ReferenceOrSchema getSchema() {
        return this.schema_;
    }

    @Override
    public String toString() {
        return super.toString() + ", required=" + this.required_;
    }
}

