/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.canon.model;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.symphonyoss.s2.canon.model.AbstractSchema;
import org.symphonyoss.s2.canon.model.Field;
import org.symphonyoss.s2.canon.model.ModelElement;
import org.symphonyoss.s2.canon.model.Operation;
import org.symphonyoss.s2.canon.model.ReferenceOrSchema;
import org.symphonyoss.s2.canon.parser.ParserContext;
import org.symphonyoss.s2.canon.parser.error.ParserError;
import org.symphonyoss.s2.canon.parser.error.UnexpectedTypeError;

public class AbstractPayload
extends ModelElement {
    private static Logger log_ = LoggerFactory.getLogger(AbstractPayload.class);
    private ReferenceOrSchema schema_;
    private boolean required_;
    private boolean multiple_;

    public AbstractPayload(Operation parent, ParserContext parserContext, String elementType) {
        super(parent, parserContext, elementType);
        this.required_ = parserContext.getBooleanNode("required", true);
        this.multiple_ = parserContext.getBooleanNode("multiple", false);
        ParserContext schemaContext = parserContext.get("schema");
        if (schemaContext == null) {
            parserContext.raise(new ParserError("%s is required", "schema"));
        } else {
            log_.debug("Found " + elementType + " schema \"" + schemaContext.getName() + "\" at " + schemaContext.getPath());
            AbstractSchema objectSchema = Field.createSchema(this, schemaContext, this.getName());
            if (objectSchema instanceof ReferenceOrSchema) {
                this.schema_ = (ReferenceOrSchema)objectSchema;
                this.add(this.schema_);
            } else {
                this.schema_ = null;
                schemaContext.raise(new UnexpectedTypeError(ReferenceOrSchema.class, (Object)objectSchema));
            }
        }
    }

    @Override
    public void validate() {
        super.validate();
        if (this.schema_ != null && !this.multiple_ && this.schema_.isResolved() && !this.schema_.getIsObjectSchema()) {
            this.getContext().raise(new ParserError(this.getElementType() + " schemas must be objects", new Object[0]));
        }
    }

    public ReferenceOrSchema getSchema() {
        return this.schema_;
    }

    public boolean getIsRequired() {
        return this.required_;
    }

    public boolean getIsMultiple() {
        return this.multiple_;
    }
}

