/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.canon.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.symphonyoss.s2.canon.model.AbstractContainerSchema;
import org.symphonyoss.s2.canon.model.AbstractSchema;
import org.symphonyoss.s2.canon.model.Component;
import org.symphonyoss.s2.canon.model.ModelElement;
import org.symphonyoss.s2.canon.model.ObjectSchema;
import org.symphonyoss.s2.canon.model.Schema;
import org.symphonyoss.s2.canon.parser.ParserContext;

public class AllOfSchema
extends AbstractContainerSchema {
    private ParserContext discriminator_;
    private List<ModelElement> fields_;
    private List<Component> superClasses_;

    public AllOfSchema(ModelElement parent, ParserContext context, ParserContext node, String name) {
        super(parent, context, node, "AllOfSchema", name);
    }

    public ParserContext getDiscriminator() {
        return this.discriminator_;
    }

    @Override
    public void validate() {
        super.validate();
        this.fields_ = new ArrayList<ModelElement>();
        this.superClasses_ = new ArrayList<Component>();
        this.gatherFields(this, this.fields_, this.superClasses_, true);
    }

    private void gatherFields(Schema schema, List<ModelElement> fields, List<Component> superClasses, boolean gatherObjects) {
        for (ModelElement e : schema.getChildren()) {
            ModelElement baseSchema = e.getBaseSchema();
            if (gatherObjects && baseSchema instanceof ObjectSchema) {
                ModelElement p = ((ObjectSchema)baseSchema).getParent();
                if (p instanceof Component) {
                    superClasses.add((Component)p);
                }
                this.gatherFields((ObjectSchema)baseSchema, fields, superClasses, false);
                continue;
            }
            fields.add(e);
        }
    }

    @Override
    protected void getReferencedTypes(Set<AbstractSchema> result) {
        super.getReferencedTypes(result);
        for (ModelElement child : this.getFields()) {
            child.getReferencedTypes(result);
        }
    }

    @Override
    protected void getSchemas(Set<AbstractSchema> result) {
        result.add(this);
    }

    @Override
    public List<Component> getSuperClasses() {
        return this.superClasses_;
    }

    @Override
    public List<ModelElement> getFields() {
        return this.fields_;
    }

    @Override
    public boolean getCanFailValidation() {
        for (ModelElement child : this.getFields()) {
            if (!child.getCanFailValidation()) continue;
            return true;
        }
        return false;
    }
}

