/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.canon.model;

import org.symphonyoss.s2.canon.model.ModelElement;
import org.symphonyoss.s2.canon.model.Type;
import org.symphonyoss.s2.canon.model.ValueMap;
import org.symphonyoss.s2.canon.parser.ParserContext;
import org.symphonyoss.s2.canon.parser.error.UnknownFormatWarning;

public class DoubleType
extends Type {
    private final Double minimum_;
    private final Double maximum_;

    public DoubleType(ModelElement parent, ParserContext context, String name) {
        super(parent, context, "Double", name);
        switch (this.getFormat()) {
            case "float": 
            case "double": 
            case "": {
                break;
            }
            default: {
                context.raise(new UnknownFormatWarning(this.getFormat()));
            }
        }
        this.minimum_ = context.getDoubleNode("minimum");
        this.maximum_ = context.getDoubleNode("maximum");
    }

    public Double getMinimum() {
        return this.minimum_;
    }

    public Double getMaximum() {
        return this.maximum_;
    }

    public String getMinimumAsString() {
        return this.minimum_ == null ? null : String.valueOf(this.minimum_);
    }

    public String getMaximumAsString() {
        return this.maximum_ == null ? null : String.valueOf(this.maximum_);
    }

    @Override
    public boolean getCanFailValidation() {
        return this.minimum_ != null || this.maximum_ != null;
    }

    @Override
    public String toString() {
        return super.toString(new ValueMap<String, Double>().append("minimum", this.minimum_).append("maximum", this.maximum_));
    }
}

