/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.canon.model;

import java.util.Map;
import java.util.Set;
import org.symphonyoss.s2.canon.model.AbstractContainerSchema;
import org.symphonyoss.s2.canon.model.AbstractSchema;
import org.symphonyoss.s2.canon.model.Component;
import org.symphonyoss.s2.canon.model.ModelElement;
import org.symphonyoss.s2.canon.model.ObjectSchema;
import org.symphonyoss.s2.canon.model.ReferenceSchema;
import org.symphonyoss.s2.canon.model.Schemas;
import org.symphonyoss.s2.canon.parser.GenerationContext;
import org.symphonyoss.s2.canon.parser.ParserContext;
import org.symphonyoss.s2.canon.parser.error.ParserError;

public class OneOfSchema
extends AbstractContainerSchema {
    public OneOfSchema(ModelElement parent, ParserContext context, ParserContext node, String name) {
        super(parent, context, node, "OneOfSchema", name);
        if (!(parent instanceof Schemas)) {
            context.raise(new ParserError("Nested in-line object definitions are not supported, move this to Components/Schemas amd refer to is with $ref", new Object[0]));
        }
    }

    @Override
    public void validate() {
        super.validate();
        for (ModelElement child : this.getChildren()) {
            if (child instanceof ObjectSchema) {
                this.getContext().raise(new ParserError("OneOf children must be declared as $ref not as in-line objects. This is a canon restriction.", new Object[0]));
                continue;
            }
            if (!(child instanceof ReferenceSchema)) continue;
            AbstractSchema type = ((ReferenceSchema)child).getType();
            if (type instanceof Component) {
                type = ((Component)type).getType();
            }
            if (type instanceof ObjectSchema) continue;
            this.getContext().raise(new ParserError("OneOf children must be declared as $ref to an object, not a %s", type == null ? "null" : type.getClass().getName()));
        }
    }

    @Override
    protected void getReferencedTypes(Set<AbstractSchema> result) {
        super.getReferencedTypes(result);
        result.add(this);
    }

    @Override
    protected void generateChildren(GenerationContext generationContext, Map<String, Object> dataModel) {
    }
}

