/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.canon.model;

import org.symphonyoss.s2.canon.model.AbstractSchema;
import org.symphonyoss.s2.canon.model.ISchemaFactory;
import org.symphonyoss.s2.canon.model.ModelElement;
import org.symphonyoss.s2.canon.parser.ParserContext;
import org.symphonyoss.s2.canon.parser.error.OnlyOneAllowedError;

class SchemaBuilder {
    private final ModelElement parent_;
    private final ParserContext context_;
    private AbstractSchema result_;
    private ParserContext resultNode_;

    public SchemaBuilder(ModelElement parent, ParserContext context) {
        this.parent_ = parent;
        this.context_ = context;
    }

    void build(String name, ISchemaFactory factory) {
        ParserContext node = this.canBuildNode(name);
        if (node != null) {
            this.result_ = factory.create(this.parent_, this.context_, node);
            this.resultNode_ = node;
        }
    }

    boolean canBuild(String name) {
        return this.canBuildNode(name) == null;
    }

    ParserContext canBuildNode(String name) {
        ParserContext node = this.context_.get(name);
        if (node != null) {
            if (this.resultNode_ == null) {
                return node;
            }
            this.context_.raise(new OnlyOneAllowedError(this.resultNode_, node));
        }
        return null;
    }

    AbstractSchema getResult() {
        return this.result_;
    }
}

