/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.canon.model;

import org.symphonyoss.s2.canon.model.AbstractSchema;
import org.symphonyoss.s2.canon.model.ArraySchema;
import org.symphonyoss.s2.canon.model.BooleanType;
import org.symphonyoss.s2.canon.model.DoubleType;
import org.symphonyoss.s2.canon.model.EnumSchema;
import org.symphonyoss.s2.canon.model.IntegerType;
import org.symphonyoss.s2.canon.model.ModelElement;
import org.symphonyoss.s2.canon.model.ObjectSchema;
import org.symphonyoss.s2.canon.model.Schema;
import org.symphonyoss.s2.canon.model.Schemas;
import org.symphonyoss.s2.canon.model.StringType;
import org.symphonyoss.s2.canon.parser.ParserContext;
import org.symphonyoss.s2.canon.parser.error.ParserError;
import org.symphonyoss.s2.canon.parser.error.ParserWarning;

public abstract class Type
extends Schema {
    private EnumSchema enum_;
    private boolean generateFacade_;

    public Type(ModelElement parent, ParserContext context, String type, String name) {
        super(parent, context, type, name);
        this.generateFacade_ = context.getBooleanNode("facade", false);
        ParserContext enumNode = this.getContext().get("enum");
        if (enumNode != null) {
            if (!this.isEnumAllowed()) {
                this.getContext().raise(new ParserError("%s is not suported on this type.", "enum"));
            } else if (!(this.getParent() instanceof Schemas)) {
                this.getContext().raise(new ParserError("%s is only supported for types defined directly in #/components/schemas", "enum"));
            } else if (enumNode.getJsonNode().isArray()) {
                this.checkFacade(context, "enum", true);
                this.enum_ = new EnumSchema(this, enumNode);
                this.add(this.enum_);
            } else {
                this.getContext().raise(new ParserError("%s must be an array", "enum"));
            }
        }
        if (this.getAttributes().containsKey("isDirectExternal")) {
            this.checkFacade(context, "Direct External types", false);
        } else if (this.getAttributes().containsKey("javaExternalPackage") || this.getAttributes().containsKey("javaExternalType")) {
            this.checkFacade(context, "External types", true);
        }
    }

    private void checkFacade(ParserContext context, String type, boolean requiredValue) {
        Boolean f = context.getBooleanNode("facade");
        if (f != null) {
            if (f != requiredValue) {
                this.getContext().raise(new ParserWarning("facade==%s is implied with %s", requiredValue, type));
            } else {
                this.getContext().raise(new ParserError("facade==%s is implied with %s, you cannot set facade to false.", requiredValue, type));
            }
        }
        this.generateFacade_ = requiredValue;
    }

    public static AbstractSchema create(ModelElement parent, ParserContext context, ParserContext node, String name) {
        switch (node.getJsonNode().asText()) {
            case "object": {
                return new ObjectSchema(parent, context, name);
            }
            case "array": {
                return new ArraySchema(parent, context, name);
            }
            case "integer": {
                return new IntegerType(parent, context, name);
            }
            case "number": {
                return new DoubleType(parent, context, name);
            }
            case "string": {
                return new StringType(parent, context, name);
            }
            case "boolean": {
                return new BooleanType(parent, context, name);
            }
        }
        context.raise(new ParserError("Type \"%s\" is of unknown type \"%s\"", context.getName(), node.getJsonNode().asText()));
        return null;
    }

    @Override
    public Schema getElementSchema() {
        return this;
    }

    @Override
    public ModelElement getElementComponent() {
        return this;
    }

    @Override
    public boolean getIsArraySchema() {
        return false;
    }

    @Override
    public boolean getIsObjectSchema() {
        return false;
    }

    @Override
    public boolean getIsGenerateFacade() {
        return this.generateFacade_;
    }

    public boolean isEnumAllowed() {
        return false;
    }

    @Override
    public EnumSchema getEnum() {
        return this.enum_;
    }

    @Override
    public boolean getHasSet() {
        return this.enum_ != null || super.getHasSet();
    }
}

