/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.canon.parser;

import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import org.symphonyoss.s2.canon.parser.RootParserContext;
import org.symphonyoss.s2.canon.parser.error.ParserError;
import org.symphonyoss.s2.canon.parser.error.ParserInfo;
import org.symphonyoss.s2.canon.parser.error.ParserProblem;
import org.symphonyoss.s2.canon.parser.error.ParserWarning;

public class BaseParserContext {
    private final RootParserContext rootParserContext_;
    private final String path_;
    private List<ParserProblem> allProblems_ = new LinkedList<ParserProblem>();
    private List<ParserError> errors_ = new LinkedList<ParserError>();
    private List<ParserWarning> warnings_ = new LinkedList<ParserWarning>();
    private List<ParserInfo> infos_ = new LinkedList<ParserInfo>();

    public BaseParserContext() {
        this.rootParserContext_ = null;
        this.path_ = "#";
    }

    public BaseParserContext(@Nullable RootParserContext rootContext, String path) {
        this.rootParserContext_ = rootContext;
        this.path_ = path;
    }

    public void raise(ParserError error) {
        if (this.rootParserContext_ != null) {
            error.setLocation(this.getPath());
            this.rootParserContext_.raise(error);
        }
        this.allProblems_.add(error);
        this.errors_.add(error);
    }

    public void raise(ParserWarning warning) {
        if (this.rootParserContext_ != null) {
            warning.setLocation(this.getPath());
            this.rootParserContext_.raise(warning);
        }
        this.allProblems_.add(warning);
        this.warnings_.add(warning);
    }

    public void raise(ParserInfo info) {
        if (this.rootParserContext_ != null) {
            info.setLocation(this.getPath());
            this.rootParserContext_.raise(info);
        }
        this.allProblems_.add(info);
        this.infos_.add(info);
    }

    public RootParserContext getRootParserContext() {
        return this.rootParserContext_;
    }

    public String getPath() {
        return this.path_;
    }

    public List<ParserProblem> getAllProblems() {
        return this.allProblems_;
    }

    public List<ParserError> getErrors() {
        return this.errors_;
    }

    public List<ParserWarning> getWarnings() {
        return this.warnings_;
    }

    public List<ParserInfo> getInfos() {
        return this.infos_;
    }
}

