/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.canon.runtime;

import java.util.Deque;
import java.util.LinkedList;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nullable;
import org.symphonyoss.s2.canon.runtime.IConsumer;

public abstract class ModelHandlerTask<T>
implements Runnable,
IConsumer<T> {
    private final ExecutorService executor_;
    private Deque<T> queue_ = new LinkedList<T>();
    private boolean isIdle_ = true;
    private boolean closed_;

    public ModelHandlerTask(ExecutorService executor) {
        this.executor_ = executor;
    }

    @Override
    public synchronized void consume(T item) {
        if (this.closed_) {
            throw new IllegalStateException("Task is closed");
        }
        this.queue_.add(item);
        this.schedule();
    }

    @Override
    public synchronized void close() {
        this.closed_ = true;
        this.schedule();
    }

    public synchronized void schedule() {
        if (this.isIdle_) {
            this.executor_.execute(this);
            this.isIdle_ = false;
        }
    }

    @Nullable
    protected synchronized T poll() {
        T request = this.queue_.poll();
        this.isIdle_ = request == null;
        return request;
    }

    @Override
    public void run() {
        T request;
        while (this.isReady() && (request = this.poll()) != null) {
            this.handleTask(request);
        }
        if (this.closed_ && this.queue_.isEmpty()) {
            this.finish();
        }
    }

    protected abstract void finish();

    protected abstract boolean isReady();

    protected abstract void handleTask(T var1);
}

