/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.canon.runtime.cache;

import org.symphonyoss.s2.canon.runtime.SynchronousProducer;
import org.symphonyoss.s2.canon.runtime.cache.IMonitor;
import org.symphonyoss.s2.canon.runtime.cache.IMonitorFactory;
import org.symphonyoss.s2.canon.runtime.cache.WeakCache;

public class WeakMonitorCache<K, V extends Comparable<V>>
extends WeakCache<K, IMonitor<V>> {
    private IMonitorFactory<K, V> monitorFactory_;

    public WeakMonitorCache(SynchronousProducer<IMonitor<V>> producer, IMonitorFactory<K, V> monitorFactory) {
        super(producer);
        this.monitorFactory_ = monitorFactory;
    }

    @Override
    public synchronized IMonitor<V> cache(K key, V value, boolean notify) {
        IMonitor existing = (IMonitor)this.fetch(key);
        if (existing != null) {
            return existing.setValueIfGreater(value);
        }
        IMonitor<V> monitor = this.monitorFactory_.create(key, value);
        this.put(key, monitor, notify);
        return monitor;
    }
}

