/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.canon.runtime.type;

import com.google.protobuf.ByteString;
import javax.annotation.Nonnull;
import org.apache.commons.codec.binary.Base64;
import org.symphonyoss.s2.common.dom.json.IJsonDomNode;
import org.symphonyoss.s2.common.dom.json.JsonBase64String;
import org.symphonyoss.s2.common.exception.InvalidValueException;

public class ByteStringBaseModelType {
    @Nonnull
    private final JsonBase64String jsonValue_;

    public ByteStringBaseModelType(ByteString value) throws InvalidValueException {
        if (value == null) {
            throw new InvalidValueException("value is required.");
        }
        this.jsonValue_ = new JsonBase64String(Base64.encodeBase64URLSafeString((byte[])value.toByteArray()));
    }

    public ByteStringBaseModelType(@Nonnull IJsonDomNode node) throws InvalidValueException {
        if (node == null) {
            throw new InvalidValueException("value is required.");
        }
        if (!(node instanceof JsonBase64String)) {
            throw new InvalidValueException("value must be an instance of ByteString not " + node.getClass().getName());
        }
        this.jsonValue_ = (JsonBase64String)node;
    }

    @Nonnull
    public ByteString getValue() {
        return this.jsonValue_.asByteString();
    }

    @Nonnull
    public JsonBase64String getJsonValue() {
        return this.jsonValue_;
    }
}

