/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.canon.runtime;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.LinkedList;
import org.symphonyoss.s2.canon.runtime.IBaseEntity;
import org.symphonyoss.s2.canon.runtime.IEntity;
import org.symphonyoss.s2.canon.runtime.IEntityFactory;
import org.symphonyoss.s2.canon.runtime.IModel;
import org.symphonyoss.s2.common.dom.DomSerializer;
import org.symphonyoss.s2.common.dom.IDomNode;
import org.symphonyoss.s2.common.dom.json.IImmutableJsonDomNode;
import org.symphonyoss.s2.common.dom.json.IJsonDomNodeProvider;
import org.symphonyoss.s2.common.dom.json.ImmutableJsonArray;
import org.symphonyoss.s2.common.dom.json.ImmutableJsonObject;
import org.symphonyoss.s2.common.exception.BadFormatException;

public abstract class EntityFactory<M extends IEntity, F extends IModel>
implements IEntityFactory<M, F> {
    protected static final DomSerializer SERIALIZER = ((DomSerializer.Builder)DomSerializer.newBuilder().withCanonicalMode(true)).build();

    public ImmutableList<M> newInstanceList(ImmutableJsonArray jsonArray) throws BadFormatException {
        LinkedList list = new LinkedList();
        for (IImmutableJsonDomNode node : jsonArray) {
            if (node instanceof ImmutableJsonObject) {
                list.add(this.newInstance((ImmutableJsonObject)node));
                continue;
            }
            throw new BadFormatException("Expected an array of JSON objectcs, but encountered a " + node.getClass().getName());
        }
        return ImmutableList.copyOf(list);
    }

    public ImmutableSet<M> newInstanceSet(ImmutableJsonArray jsonArray) throws BadFormatException {
        HashSet list = new HashSet();
        for (IImmutableJsonDomNode node : jsonArray) {
            if (node instanceof ImmutableJsonObject) {
                if (list.add(this.newInstance((ImmutableJsonObject)node))) continue;
                throw new BadFormatException("Duplicate value " + node + " encountered in Set.");
            }
            throw new BadFormatException("Expected an array of JSON objectcs, but encountered a " + node.getClass().getName());
        }
        return ImmutableSet.copyOf(list);
    }

    public static abstract class Builder
    implements IJsonDomNodeProvider,
    IBaseEntity {
        public abstract ImmutableJsonObject getJsonObject();

        @Override
        public IImmutableJsonDomNode getJsonDomNode() {
            return this.getJsonObject();
        }

        @Override
        public String serialize() {
            return SERIALIZER.serialize((IDomNode)this.getJsonObject());
        }
    }
}

