/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.canon.runtime;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.symphonyoss.s2.canon.runtime.IEntityHandler;
import org.symphonyoss.s2.canon.runtime.IModel;
import org.symphonyoss.s2.canon.runtime.exception.JapiException;
import org.symphonyoss.s2.canon.runtime.http.RequestContext;
import org.symphonyoss.s2.fugue.di.ComponentDescriptor;

public abstract class PathHandler<M extends IModel>
implements IEntityHandler {
    private static final Logger log_ = LoggerFactory.getLogger(PathHandler.class);
    private final int variableCnt_;
    private final String[] parts_;
    private final int partsLength_;

    public PathHandler(int variableCnt, String[] parts) {
        this.parts_ = parts;
        this.variableCnt_ = variableCnt;
        int cnt = 0;
        for (String s : this.parts_) {
            cnt += s.length();
        }
        this.partsLength_ = cnt;
    }

    public abstract M getModel();

    public ComponentDescriptor getComponentDescriptor() {
        return new ComponentDescriptor();
    }

    @Override
    public boolean handle(RequestContext context) throws IOException {
        List<String> variables = this.getVariablesIfCanHandle(context.getRequest().getPathInfo());
        if (variables == null) {
            return false;
        }
        try {
            this.handle(context, variables);
        }
        catch (JapiException e) {
            log_.error("Failed to service REST request", (Throwable)e);
            context.error(e);
            context.sendErrorResponse(e.getHttpStatusCode());
        }
        return true;
    }

    @Nullable
    List<String> getVariablesIfCanHandle(String path) {
        if (path == null || path.length() < 2) {
            return null;
        }
        int part = 0;
        int partIndex = 0;
        ArrayList<String> variables = new ArrayList<String>();
        StringBuilder var = null;
        System.out.printf("Try path \"%s\"\n", path);
        for (int i = 0; i < path.length(); ++i) {
            if (var == null) {
                if (partIndex >= this.parts_[part].length()) {
                    var = new StringBuilder();
                    var.append(path.charAt(i));
                    ++part;
                    partIndex = 1;
                    continue;
                }
                if (path.charAt(i) == this.parts_[part].charAt(partIndex)) {
                    ++partIndex;
                    continue;
                }
                System.out.println(this.parts_[part] + " not matched at " + partIndex + " by " + path.substring(i));
                return null;
            }
            if (path.charAt(i) == '/') {
                variables.add(var.toString());
                var = null;
                if (part < this.parts_.length) continue;
                System.out.println("/ not matched by " + path.substring(i));
                return null;
            }
            var.append(path.charAt(i));
        }
        if (this.parts_.length > part && partIndex >= this.parts_[part].length()) {
            ++part;
            partIndex = 0;
        }
        if (part < this.parts_.length) {
            System.out.println("No match for part \"" + this.parts_[part] + "\" by whole of " + path);
            return null;
        }
        if (var != null) {
            variables.add(var.toString());
        }
        if (variables.size() != this.variableCnt_) {
            System.out.println("Parts match but wanted " + this.variableCnt_ + " variables and found " + variables.size());
            return null;
        }
        System.out.println("Handle " + path + " by " + this.getPath());
        for (String s : variables) {
            System.out.println("with " + s);
        }
        return variables;
    }

    @Override
    public int getPartsLength() {
        return this.partsLength_;
    }

    protected abstract void handle(RequestContext var1, List<String> var2) throws IOException, JapiException;

    public void unsupportedMethod(RequestContext context) throws IOException {
        context.getResponse().sendError(405, "Method \"" + (Object)((Object)context.getMethod()) + "\" is not supported.");
    }
}

