/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.canon.runtime;

import java.io.IOException;
import java.io.Reader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.symphonyoss.s2.canon.runtime.IEntity;
import org.symphonyoss.s2.canon.runtime.IModelRegistry;
import org.symphonyoss.s2.common.exception.InvalidValueException;
import org.symphonyoss.s2.fugue.core.trace.ITraceContext;
import org.symphonyoss.s2.fugue.pipeline.IThreadSafeConsumer;

public abstract class EntityConsumer<P, E extends IEntity, C extends IThreadSafeConsumer<E>>
implements IThreadSafeConsumer<P> {
    private static final Logger log_ = LoggerFactory.getLogger(EntityConsumer.class);
    private final IModelRegistry modelRegistry_;
    private final Class<E> entityType_;
    private final C consumer_;
    private final IThreadSafeConsumer<P> invalidMessageConsumer_;

    public EntityConsumer(IModelRegistry modelRegistry, Class<E> entityType, C consumer, IThreadSafeConsumer<P> invalidMessageConsumer) {
        this.modelRegistry_ = modelRegistry;
        this.entityType_ = entityType;
        this.consumer_ = consumer;
        this.invalidMessageConsumer_ = invalidMessageConsumer;
    }

    public void consume(P item, ITraceContext trace) {
        try {
            IEntity modelObject = this.modelRegistry_.parseOne(this.getReader(item));
            if (this.entityType_.isInstance(modelObject)) {
                this.consumer_.consume(this.entityType_.cast(modelObject), trace);
            } else {
                log_.error("Received an entity which is not an instance of " + this.entityType_.getName());
                this.invalidMessageConsumer_.consume(item, trace);
            }
        }
        catch (IOException | InvalidValueException e) {
            log_.error("Received an entity which is not a known type", e);
            this.invalidMessageConsumer_.consume(item, trace);
        }
    }

    protected abstract Reader getReader(P var1);

    public void close() {
        this.consumer_.close();
    }
}

