/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.canon.runtime;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.symphonyoss.s2.canon.runtime.IEntityHandler;
import org.symphonyoss.s2.canon.runtime.IModelServlet;
import org.symphonyoss.s2.canon.runtime.http.HttpMethod;
import org.symphonyoss.s2.canon.runtime.http.RequestContext;
import org.symphonyoss.s2.fugue.core.trace.ITraceContext;
import org.symphonyoss.s2.fugue.core.trace.ITraceContextFactory;

public abstract class ModelServlet
extends HttpServlet
implements IModelServlet {
    private static final long serialVersionUID = 1L;
    private final ITraceContextFactory traceFactory_;
    private final TreeMap<Integer, List<IEntityHandler>> handlerMap_ = new TreeMap(new Comparator<Integer>(){

        @Override
        public int compare(Integer a, Integer b) {
            if (a > b) {
                return -1;
            }
            if (a < b) {
                return 1;
            }
            return 0;
        }
    });

    public ModelServlet(ITraceContextFactory traceFactory) {
        this.traceFactory_ = traceFactory;
    }

    public void register(IEntityHandler handler) {
        List<IEntityHandler> list = this.handlerMap_.get(handler.getPartsLength());
        if (list == null) {
            list = new ArrayList<IEntityHandler>();
            this.handlerMap_.put(handler.getPartsLength(), list);
        }
        list.add(handler);
    }

    private void handle(HttpMethod method, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        ITraceContext trace = this.traceFactory_.createTransaction("HTTP " + (Object)((Object)method), UUID.randomUUID().toString());
        RequestContext context = new RequestContext(method, req, resp, trace);
        for (List<IEntityHandler> list : this.handlerMap_.values()) {
            for (IEntityHandler handler : list) {
                if (!handler.handle(context)) continue;
                trace.finished();
                return;
            }
        }
        context.error("No handler found for " + context.getRequest().getPathInfo(), new Object[0]);
        context.sendErrorResponse(404);
        trace.aborted();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handle(HttpMethod.Get, req, resp);
    }

    protected long getLastModified(HttpServletRequest req) {
        return super.getLastModified(req);
    }

    protected void doHead(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doHead(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handle(HttpMethod.Post, req, resp);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handle(HttpMethod.Put, req, resp);
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handle(HttpMethod.Delete, req, resp);
    }
}

