/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.canon.runtime;

import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;

public abstract class JsonArrayParser {
    private ByteArrayOutputStream inputBufferStream_ = new ByteArrayOutputStream();
    private boolean inQuotedString_;
    private boolean inEscape_;
    private boolean arrayDocument_;
    private int arrayDepth_;
    private int objectDepth_;

    public void process(byte[] inputBuffer_, int nbytes) {
        int offset = 0;
        int len = 0;
        int i = 0;
        while (i < nbytes) {
            if (this.inQuotedString_) {
                switch (inputBuffer_[i]) {
                    case 92: {
                        this.inEscape_ = !this.inEscape_;
                        break;
                    }
                    case 34: {
                        if (this.inEscape_) {
                            this.inEscape_ = false;
                            break;
                        }
                        this.inQuotedString_ = false;
                    }
                }
            } else {
                boolean consume = false;
                switch (inputBuffer_[i]) {
                    case 34: {
                        this.inQuotedString_ = true;
                        break;
                    }
                    case 123: {
                        ++this.objectDepth_;
                        break;
                    }
                    case 125: {
                        --this.objectDepth_;
                        break;
                    }
                    case 91: {
                        if (this.objectDepth_ == 0 && this.arrayDepth_ == 0) {
                            while (i < nbytes - 1 && inputBuffer_[i + 1] <= 32) {
                                ++i;
                            }
                            offset = i + 1;
                            len = -1;
                            this.arrayDocument_ = true;
                        }
                        ++this.arrayDepth_;
                        break;
                    }
                    case 93: {
                        consume = this.arrayDepth_ == 1 && this.objectDepth_ == 0;
                        --this.arrayDepth_;
                        break;
                    }
                    case 44: {
                        boolean bl = consume = this.arrayDepth_ == 1 && this.objectDepth_ == 0;
                    }
                }
                if (consume) {
                    this.inputBufferStream_.write(inputBuffer_, offset, len);
                    String input = new String(this.inputBufferStream_.toByteArray(), StandardCharsets.UTF_8);
                    this.handle(input);
                    this.inputBufferStream_.reset();
                    while (i < nbytes - 1 && inputBuffer_[i + 1] <= 32) {
                        ++i;
                    }
                    len = -1;
                    offset = i + 1;
                }
            }
            ++i;
            ++len;
        }
        if (len > 0) {
            if (this.arrayDocument_ && inputBuffer_[offset + len - 1] == 93) {
                --len;
            }
            this.inputBufferStream_.write(inputBuffer_, offset, len);
        }
    }

    protected abstract void handle(String var1);

    public void close() {
        if (this.inputBufferStream_.size() > 0) {
            String input = new String(this.inputBufferStream_.toByteArray(), StandardCharsets.UTF_8);
            this.handle(input);
        }
    }
}

