/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.canon.runtime;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import org.symphonyoss.s2.canon.runtime.IEntity;
import org.symphonyoss.s2.canon.runtime.IEntityConsumer;
import org.symphonyoss.s2.canon.runtime.IEntityFactory;
import org.symphonyoss.s2.canon.runtime.IModelRegistry;
import org.symphonyoss.s2.canon.runtime.JsonArrayParser;
import org.symphonyoss.s2.common.dom.json.IJsonDomNode;
import org.symphonyoss.s2.common.dom.json.IJsonObject;
import org.symphonyoss.s2.common.dom.json.ImmutableJsonObject;
import org.symphonyoss.s2.common.dom.json.JsonValue;
import org.symphonyoss.s2.common.dom.json.jackson.JacksonAdaptor;
import org.symphonyoss.s2.common.exception.InvalidValueException;
import org.symphonyoss.s2.common.fault.TransactionFault;

public class ModelRegistry
implements IModelRegistry {
    private Map<String, IEntityFactory<?, ?, ?>> factoryMap_ = new HashMap();

    public ModelRegistry withFactories(IEntityFactory<?, ?, ?> ... factories) {
        for (IEntityFactory<?, ?, ?> factory : factories) {
            this.factoryMap_.put(factory.getCanonType(), factory);
        }
        return this;
    }

    @Override
    public IEntity newInstance(ImmutableJsonObject jsonObject) throws InvalidValueException {
        String typeId = jsonObject.getString("_type");
        IEntityFactory<?, ?, ?> factory = this.factoryMap_.get(typeId);
        if (factory == null) {
            throw new InvalidValueException("Unknown type \"" + typeId + "\"");
        }
        return factory.newInstance(jsonObject);
    }

    public static ImmutableJsonObject parseOneJsonObject(Reader reader) throws InvalidValueException {
        ObjectMapper mapper = new ObjectMapper().configure(JsonParser.Feature.AUTO_CLOSE_SOURCE, false);
        try {
            JsonNode tree = mapper.readTree(reader);
            IJsonDomNode adapted = JacksonAdaptor.adapt((JsonNode)tree);
            if (adapted instanceof IJsonObject) {
                return (ImmutableJsonObject)adapted.immutify();
            }
            throw new InvalidValueException("Expected a JSON Object but read a " + adapted.getClass().getName());
        }
        catch (IOException e) {
            throw new InvalidValueException("Failed to parse input", (Throwable)e);
        }
    }

    public static JsonValue<?, ?> parseOneJsonValue(Reader reader) throws InvalidValueException {
        ObjectMapper mapper = new ObjectMapper().configure(JsonParser.Feature.AUTO_CLOSE_SOURCE, false);
        try {
            JsonNode tree = mapper.readTree(reader);
            if (tree.isValueNode()) {
                return (JsonValue)JacksonAdaptor.adapt((JsonNode)tree);
            }
            throw new InvalidValueException("Expected a JSON value but read a " + tree.getClass().getName());
        }
        catch (IOException e) {
            throw new InvalidValueException("Failed to parse input", (Throwable)e);
        }
    }

    @Override
    public IEntity parseOne(Reader reader) throws IOException, InvalidValueException {
        return this.newInstance(ModelRegistry.parseOneJsonObject(reader));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseStream(InputStream in, final IEntityConsumer consumer) throws InvalidValueException, IOException {
        byte[] buf = new byte[1024];
        try (JsonArrayParser arrayParser = new JsonArrayParser(){

            @Override
            protected void handle(String input) {
                try {
                    IEntity result = ModelRegistry.this.parseOne(new StringReader(input));
                    consumer.consume(result);
                }
                catch (IOException | InvalidValueException e) {
                    throw new TransactionFault(e);
                }
            }
        };){
            int nbytes;
            while ((nbytes = in.read(buf)) != -1) {
                arrayParser.process(buf, nbytes);
            }
        }
    }
}

