/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.canon.runtime.type;

import javax.annotation.Nonnull;
import org.symphonyoss.s2.common.dom.json.IJsonDomNode;
import org.symphonyoss.s2.common.dom.json.JsonBoolean;
import org.symphonyoss.s2.common.exception.InvalidValueException;

public class BooleanBaseModelType {
    @Nonnull
    private final JsonBoolean jsonValue_;

    public BooleanBaseModelType(Boolean value) throws InvalidValueException {
        if (value == null) {
            throw new InvalidValueException("value is required.");
        }
        this.jsonValue_ = new JsonBoolean(value);
    }

    public BooleanBaseModelType(@Nonnull IJsonDomNode node) throws InvalidValueException {
        if (node == null) {
            throw new InvalidValueException("value is required.");
        }
        if (!(node instanceof JsonBoolean)) {
            throw new InvalidValueException("value must be an instance of Boolean not " + node.getClass().getName());
        }
        this.jsonValue_ = (JsonBoolean)node;
    }

    @Nonnull
    public Boolean getValue() {
        return this.jsonValue_.asBoolean();
    }

    @Nonnull
    public JsonBoolean getJsonValue() {
        return this.jsonValue_;
    }
}

