/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.canon.runtime.type;

import javax.annotation.Nonnull;
import org.symphonyoss.s2.common.dom.json.IJsonDomNode;
import org.symphonyoss.s2.common.dom.json.JsonInteger;
import org.symphonyoss.s2.common.exception.InvalidValueException;

public class IntegerBaseModelType {
    @Nonnull
    private final JsonInteger jsonValue_;

    public IntegerBaseModelType(Integer value) throws InvalidValueException {
        if (value == null) {
            throw new InvalidValueException("value is required.");
        }
        this.jsonValue_ = new JsonInteger(value);
    }

    public IntegerBaseModelType(@Nonnull IJsonDomNode node) throws InvalidValueException {
        if (node == null) {
            throw new InvalidValueException("value is required.");
        }
        if (!(node instanceof JsonInteger)) {
            throw new InvalidValueException("value must be an instance of Integer not " + node.getClass().getName());
        }
        this.jsonValue_ = (JsonInteger)node;
    }

    @Nonnull
    public Integer getValue() {
        return this.jsonValue_.asInteger();
    }

    @Nonnull
    public JsonInteger getJsonValue() {
        return this.jsonValue_;
    }
}

