/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.canon.runtime.type;

import javax.annotation.Nonnull;
import org.symphonyoss.s2.common.dom.json.IJsonDomNode;
import org.symphonyoss.s2.common.dom.json.JsonString;
import org.symphonyoss.s2.common.exception.InvalidValueException;

public class StringBaseModelType {
    @Nonnull
    private final JsonString jsonValue_;

    public StringBaseModelType(String value) throws InvalidValueException {
        if (value == null) {
            throw new InvalidValueException("value is required.");
        }
        this.jsonValue_ = new JsonString(value);
    }

    public StringBaseModelType(@Nonnull IJsonDomNode node) throws InvalidValueException {
        if (node == null) {
            throw new InvalidValueException("value is required.");
        }
        if (!(node instanceof JsonString)) {
            throw new InvalidValueException("value must be an instance of String not " + node.getClass().getName());
        }
        this.jsonValue_ = (JsonString)node;
    }

    @Nonnull
    public String getValue() {
        return this.jsonValue_.asString();
    }

    @Nonnull
    public JsonString getJsonValue() {
        return this.jsonValue_;
    }
}

