/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.canon.runtime;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.LinkedList;
import org.symphonyoss.s2.canon.runtime.IEntity;
import org.symphonyoss.s2.canon.runtime.IEntityFactory;
import org.symphonyoss.s2.canon.runtime.IModel;
import org.symphonyoss.s2.common.dom.json.IImmutableJsonDomNode;
import org.symphonyoss.s2.common.dom.json.ImmutableJsonArray;
import org.symphonyoss.s2.common.dom.json.ImmutableJsonObject;
import org.symphonyoss.s2.common.exception.BadFormatException;

public abstract class EntityFactory<E extends IEntity, B extends IEntity, M extends IModel>
implements IEntityFactory<E, B, M> {
    private final M model_;

    public EntityFactory(M model) {
        this.model_ = model;
    }

    @Override
    public M getModel() {
        return this.model_;
    }

    @Override
    public ImmutableList<E> newInstanceList(ImmutableJsonArray jsonArray) throws BadFormatException {
        LinkedList list = new LinkedList();
        for (IImmutableJsonDomNode node : jsonArray) {
            if (node instanceof ImmutableJsonObject) {
                list.add(this.newInstance((ImmutableJsonObject)node));
                continue;
            }
            throw new BadFormatException("Expected an array of JSON objectcs, but encountered a " + node.getClass().getName());
        }
        return ImmutableList.copyOf(list);
    }

    @Override
    public ImmutableSet<E> newInstanceSet(ImmutableJsonArray jsonArray) throws BadFormatException {
        HashSet list = new HashSet();
        for (IImmutableJsonDomNode node : jsonArray) {
            if (node instanceof ImmutableJsonObject) {
                if (list.add(this.newInstance((ImmutableJsonObject)node))) continue;
                throw new BadFormatException("Duplicate value " + node + " encountered in Set.");
            }
            throw new BadFormatException("Expected an array of JSON objectcs, but encountered a " + node.getClass().getName());
        }
        return ImmutableSet.copyOf(list);
    }
}

