/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.canon.runtime;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.symphonyoss.s2.canon.runtime.IEntity;
import org.symphonyoss.s2.canon.runtime.IEntityConsumer;
import org.symphonyoss.s2.canon.runtime.IEntityFactory;
import org.symphonyoss.s2.canon.runtime.IModel;
import org.symphonyoss.s2.canon.runtime.IModelRegistry;
import org.symphonyoss.s2.canon.runtime.JsonArrayParser;
import org.symphonyoss.s2.common.dom.json.IJsonDomNode;
import org.symphonyoss.s2.common.dom.json.IJsonObject;
import org.symphonyoss.s2.common.dom.json.ImmutableJsonObject;
import org.symphonyoss.s2.common.dom.json.JsonValue;
import org.symphonyoss.s2.common.dom.json.jackson.JacksonAdaptor;
import org.symphonyoss.s2.common.exception.BadFormatException;
import org.symphonyoss.s2.common.fault.TransactionFault;
import org.symphonyoss.s2.fugue.di.Cardinality;
import org.symphonyoss.s2.fugue.di.ComponentDescriptor;
import org.symphonyoss.s2.fugue.di.IBinder;

public class ModelRegistry
implements IModelRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(ModelRegistry.class);
    private Map<String, IEntityFactory<?, ?, ?>> factoryMap_ = new HashMap();
    private List<IModel> models_ = new LinkedList<IModel>();

    public ComponentDescriptor getComponentDescriptor() {
        return new ComponentDescriptor().addProvidedInterface(IModelRegistry.class).addDependency(IModel.class, (IBinder)new IBinder<IModel>(){

            public void bind(IModel v) {
                ModelRegistry.this.register(v);
            }
        }, Cardinality.oneOrMore);
    }

    @Override
    public IModelRegistry register(IModel factory) {
        this.models_.add(factory);
        factory.registerWith(this);
        return this;
    }

    @Override
    public IModelRegistry register(String name, IEntityFactory<?, ?, ?> factory) {
        this.factoryMap_.put(name, factory);
        return this;
    }

    @Override
    public IEntity newInstance(ImmutableJsonObject jsonObject) throws BadFormatException {
        String typeId = jsonObject.getString("_type");
        IEntityFactory<?, ?, ?> factory = this.factoryMap_.get(typeId);
        if (factory == null) {
            throw new BadFormatException("Unknown type \"" + typeId + "\"");
        }
        return factory.newInstance(jsonObject);
    }

    public static ImmutableJsonObject parseOneJsonObject(Reader reader) throws BadFormatException {
        ObjectMapper mapper = new ObjectMapper().configure(JsonParser.Feature.AUTO_CLOSE_SOURCE, false);
        try {
            JsonNode tree = mapper.readTree(reader);
            IJsonDomNode adapted = JacksonAdaptor.adapt((JsonNode)tree);
            if (adapted instanceof IJsonObject) {
                return (ImmutableJsonObject)adapted.immutify();
            }
            throw new BadFormatException("Expected a JSON Object but read a " + adapted.getClass().getName());
        }
        catch (IOException e) {
            throw new BadFormatException("Failed to parse input", (Throwable)e);
        }
    }

    public static JsonValue<?, ?> parseOneJsonValue(Reader reader) throws BadFormatException {
        ObjectMapper mapper = new ObjectMapper().configure(JsonParser.Feature.AUTO_CLOSE_SOURCE, false);
        try {
            JsonNode tree = mapper.readTree(reader);
            if (tree.isValueNode()) {
                return (JsonValue)JacksonAdaptor.adapt((JsonNode)tree);
            }
            throw new BadFormatException("Expected a JSON value but read a " + tree.getClass().getName());
        }
        catch (IOException e) {
            throw new BadFormatException("Failed to parse input", (Throwable)e);
        }
    }

    @Override
    public IEntity parseOne(Reader reader) throws IOException, BadFormatException {
        return this.newInstance(ModelRegistry.parseOneJsonObject(reader));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseStream(InputStream in, final IEntityConsumer consumer) throws BadFormatException, IOException {
        byte[] buf = new byte[1024];
        try (JsonArrayParser arrayParser = new JsonArrayParser(){

            @Override
            protected void handle(String input) {
                try {
                    IEntity result = ModelRegistry.this.parseOne(new StringReader(input));
                    consumer.consume(result);
                }
                catch (IOException | BadFormatException e) {
                    throw new TransactionFault(e);
                }
            }
        };){
            int nbytes;
            while ((nbytes = in.read(buf)) != -1) {
                arrayParser.process(buf, nbytes);
            }
        }
    }
}

