/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.canon.runtime.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.symphonyoss.s2.canon.runtime.IBaseEntity;
import org.symphonyoss.s2.canon.runtime.IEntity;
import org.symphonyoss.s2.canon.runtime.IEntityFactory;
import org.symphonyoss.s2.canon.runtime.ModelRegistry;
import org.symphonyoss.s2.canon.runtime.TypeDefBuilder;
import org.symphonyoss.s2.canon.runtime.http.HttpMethod;
import org.symphonyoss.s2.canon.runtime.http.ParameterLocation;
import org.symphonyoss.s2.common.dom.json.ImmutableJsonObject;
import org.symphonyoss.s2.common.dom.json.JsonValue;
import org.symphonyoss.s2.common.exception.BadFormatException;

public class RequestContext {
    public static final String JSON_CONTENT_TYPE = "application/json; charset=utf-8";
    private static Logger log_ = LoggerFactory.getLogger(RequestContext.class);
    private final HttpMethod method_;
    private final HttpServletRequest request_;
    private final HttpServletResponse response_;
    private Map<String, Cookie> cookieMap_;
    private Map<String, String> pathMap_;
    private List<String> errors_ = new LinkedList<String>();

    public RequestContext(HttpMethod method, HttpServletRequest request, HttpServletResponse response) {
        this.method_ = method;
        this.request_ = request;
        this.response_ = response;
    }

    public HttpMethod getMethod() {
        return this.method_;
    }

    public HttpServletRequest getRequest() {
        return this.request_;
    }

    public HttpServletResponse getResponse() {
        return this.response_;
    }

    @Nullable
    public Long getParameterAsLong(String name, ParameterLocation location, boolean required) {
        return this.asLong(name, this.getParameterAsString(name, location, required));
    }

    public Integer getParameterAsInteger(String name, ParameterLocation location, boolean required) {
        return this.asInteger(name, this.getParameterAsString(name, location, required));
    }

    public ByteString getParameterAsByteString(String name, ParameterLocation location, boolean required) {
        return this.asByteString(name, this.getParameterAsString(name, location, required));
    }

    @Nullable
    public Long asLong(String parameterName, String value) {
        if (value == null) {
            return null;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            this.error("Parameter %s requires a Long value but we found \"%s\"", parameterName, value);
            return null;
        }
    }

    @Nullable
    public Integer asInteger(String parameterName, String value) {
        if (value == null) {
            return null;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            this.error("Parameter %s requires an Integer value but we found \"%s\"", value);
            return null;
        }
    }

    @Nullable
    public ByteString asByteString(String parameterName, String value) {
        if (value == null) {
            return null;
        }
        if (!Base64.isBase64((String)value)) {
            this.error("Parameter %s requires a Base64 value but we found \"%s\"", parameterName, value);
            return null;
        }
        return ByteString.copyFrom((byte[])Base64.decodeBase64((String)value));
    }

    public String getParameterAsString(String name, ParameterLocation location, boolean required) {
        String value = null;
        switch (location) {
            case Cookie: {
                if (this.cookieMap_ == null) {
                    this.cookieMap_ = new HashMap<String, Cookie>();
                    for (Cookie cookie : this.request_.getCookies()) {
                        this.cookieMap_.put(cookie.getName(), cookie);
                    }
                }
                value = this.cookieMap_.get(name).getValue();
                break;
            }
            case Header: {
                value = this.request_.getHeader(name);
                break;
            }
            case Path: {
                if (this.pathMap_ != null) break;
                this.pathMap_ = new HashMap<String, String>();
                String pathInfo = this.request_.getPathInfo();
                if (pathInfo != null) {
                    String[] parts = pathInfo.split("/");
                    int i = 1;
                    while (parts.length > i) {
                        this.pathMap_.put(parts[i++], parts[i++]);
                    }
                }
                value = this.pathMap_.get(name);
                break;
            }
            case Query: {
                value = this.request_.getParameter(name);
            }
        }
        if (value == null && required) {
            this.errors_.add(String.format("Required %s parameter \"%s\" is missing", new Object[]{location, name}));
        }
        return value;
    }

    public boolean preConditionsAreMet() {
        if (this.errors_.isEmpty()) {
            return true;
        }
        this.sendErrorResponse(400);
        return false;
    }

    public void sendOKResponse() {
        this.response_.setStatus(200);
    }

    public void sendOKResponse(IBaseEntity response) throws IOException {
        this.response_.setStatus(200);
        this.response_.getWriter().println(response.serialize());
    }

    public void sendErrorResponse(int statusCode) {
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode arrayNode = mapper.createArrayNode();
        for (String error : this.errors_) {
            arrayNode.add(error);
        }
        try {
            this.response_.setContentType(JSON_CONTENT_TYPE);
            this.response_.setStatus(statusCode);
            this.response_.getWriter().println(arrayNode.toString());
        }
        catch (IOException e) {
            log_.error("Failed to send error response", (Throwable)e);
        }
    }

    public void error(String format, Object ... args) {
        this.errors_.add(String.format(format, args));
    }

    public void error(Throwable t) {
        String message = t.getMessage();
        if (message == null) {
            message = t.toString();
        }
        this.errors_.add(String.format(message, new Object[0]));
    }

    public <E extends IEntity> E parsePayload(IEntityFactory<E, ?, ?> factory) {
        try {
            ImmutableJsonObject jsonObject = ModelRegistry.parseOneJsonObject(this.getRequest().getReader());
            return factory.newInstance(jsonObject);
        }
        catch (IOException | BadFormatException e) {
            log_.error("Failed to parse payload", e);
            this.error("Unable to parse payload", new Object[0]);
            String message = e.getMessage();
            if (message != null) {
                this.error(message, new Object[0]);
            }
            return null;
        }
    }

    public <M, T> M parsePayload(TypeDefBuilder<M, T> builder) {
        try {
            JsonValue<?, ?> jsonObject = ModelRegistry.parseOneJsonValue(this.getRequest().getReader());
            return builder.build(jsonObject);
        }
        catch (IOException | BadFormatException e) {
            log_.error("Failed to parse payload", e);
            this.error("Unable to parse payload", new Object[0]);
            String message = e.getMessage();
            if (message != null) {
                this.error(message, new Object[0]);
            }
            return null;
        }
    }
}

