/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.canon.runtime;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import javax.servlet.AsyncContext;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.symphonyoss.s2.canon.runtime.IBaseEntity;
import org.symphonyoss.s2.canon.runtime.JsonArrayParser;
import org.symphonyoss.s2.canon.runtime.ModelHandlerTask;
import org.symphonyoss.s2.canon.runtime.exception.CanonException;
import org.symphonyoss.s2.common.exception.InvalidValueException;

public abstract class AbstractRequestManager<P, R extends IBaseEntity> {
    private final ServletInputStream in_;
    private final ServletOutputStream out_;
    private final AsyncContext async_;
    private final ExecutorService processExecutor_;
    private final ExecutorService responseExecutor_;
    private ModelHandlerTask<String> processTask_;
    private ModelHandlerTask<R> responseTask_;
    private byte[] inputBuffer_ = new byte[1024];
    private JsonArrayParser arrayParser_;

    public AbstractRequestManager(ServletInputStream in, ServletOutputStream out, AsyncContext async, ExecutorService processExecutor, ExecutorService responseExecutor) {
        this.in_ = in;
        this.out_ = out;
        this.async_ = async;
        this.processExecutor_ = processExecutor;
        this.responseExecutor_ = responseExecutor;
        this.responseTask_ = new ModelHandlerTask<R>(this.responseExecutor_){
            R responseBuffer_;
            int rowCnt_;
            {
                this.responseBuffer_ = null;
                this.rowCnt_ = 0;
            }

            @Override
            protected void handleTask(R response) {
                try {
                    System.err.println("sendResponse: " + response);
                    if (this.responseBuffer_ != null) {
                        if (this.rowCnt_++ == 0) {
                            AbstractRequestManager.this.out_.print("[\n " + this.responseBuffer_.serialize());
                        } else {
                            AbstractRequestManager.this.out_.print(",\n " + this.responseBuffer_.serialize());
                        }
                    }
                    this.responseBuffer_ = response;
                }
                catch (IOException e) {
                    AbstractRequestManager.this.onError(e);
                }
            }

            @Override
            protected boolean isReady() {
                boolean ready = AbstractRequestManager.this.out_.isReady();
                System.err.println("isReady() = " + ready);
                return ready;
            }

            @Override
            protected void finish() {
                System.err.println("Response finish()");
                if (this.responseBuffer_ != null) {
                    try {
                        if (this.rowCnt_++ == 0) {
                            AbstractRequestManager.this.out_.print(this.responseBuffer_.serialize() + "\n");
                        } else {
                            AbstractRequestManager.this.out_.print(",\n " + this.responseBuffer_.serialize() + "\n]\n");
                        }
                    }
                    catch (IOException e) {
                        AbstractRequestManager.this.onError(e);
                    }
                }
                AbstractRequestManager.this.async_.complete();
            }
        };
        this.processTask_ = new ModelHandlerTask<String>(this.processExecutor_){

            @Override
            protected void handleTask(String request) {
                block4: {
                    try {
                        AbstractRequestManager.this.handleRequest(request);
                    }
                    catch (InvalidValueException e) {
                        HttpServletResponse response = (HttpServletResponse)AbstractRequestManager.this.getAsync().getResponse();
                        if (!response.isCommitted()) {
                            response.setStatus(400);
                        }
                    }
                    catch (CanonException e) {
                        HttpServletResponse response = (HttpServletResponse)AbstractRequestManager.this.getAsync().getResponse();
                        if (response.isCommitted()) break block4;
                        response.setStatus(e.getHttpStatusCode());
                    }
                }
            }

            @Override
            protected boolean isReady() {
                return true;
            }

            @Override
            protected void finish() {
                AbstractRequestManager.this.finishRequest();
            }
        };
        this.arrayParser_ = new JsonArrayParser(){

            @Override
            protected void handle(String input) {
                AbstractRequestManager.this.processTask_.consume(input);
            }
        };
    }

    protected abstract void finishRequest();

    protected ModelHandlerTask<String> getProcessTask() {
        return this.processTask_;
    }

    protected ModelHandlerTask<R> getResponseTask() {
        return this.responseTask_;
    }

    protected AsyncContext getAsync() {
        return this.async_;
    }

    protected abstract void handleRequest(String var1) throws InvalidValueException, CanonException;

    public void onDataAvailable() throws IOException {
        System.err.println("onDataAvailable()");
        do {
            System.err.println("onDataAvailable() - LOOP");
            int nbytes = this.in_.read(this.inputBuffer_);
            if (nbytes == -1) {
                System.err.println("onDataAvailable() - EOF");
                return;
            }
            this.arrayParser_.process(this.inputBuffer_, nbytes);
        } while (this.in_.isReady());
        System.err.println("onDataAvailable() - DONE");
    }

    public void onAllDataRead() throws IOException {
        System.err.println("onAllDataRead()");
        this.arrayParser_.close();
        this.processTask_.close();
    }

    public void onWritePossible() throws IOException {
        System.err.println("onWritePossible()");
        this.responseTask_.schedule();
    }

    public void onError(Throwable t) {
        System.err.println("ERROR");
        t.printStackTrace();
        this.async_.complete();
    }
}

