/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.canon.runtime.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.symphonyoss.s2.canon.runtime.IBaseEntity;
import org.symphonyoss.s2.canon.runtime.IEntity;
import org.symphonyoss.s2.canon.runtime.IModelRegistry;
import org.symphonyoss.s2.canon.runtime.ModelRegistry;
import org.symphonyoss.s2.canon.runtime.TypeDefBuilder;
import org.symphonyoss.s2.canon.runtime.exception.BadRequestException;
import org.symphonyoss.s2.canon.runtime.http.HttpMethod;
import org.symphonyoss.s2.canon.runtime.http.ParameterLocation;
import org.symphonyoss.s2.common.dom.json.ImmutableJsonObject;
import org.symphonyoss.s2.common.dom.json.JsonValue;
import org.symphonyoss.s2.common.immutable.ImmutableByteArray;
import org.symphonyoss.s2.fugue.core.trace.ITraceContext;

public class RequestContext {
    public static final String JSON_CONTENT_TYPE = "application/json; charset=utf-8";
    public static final String FORM_CONTENT_TYPE = "application/x-www-form-urlencoded; charset=UTF-8";
    private static Logger log_ = LoggerFactory.getLogger(RequestContext.class);
    private final HttpMethod method_;
    private final HttpServletRequest request_;
    private final HttpServletResponse response_;
    private final ITraceContext trace_;
    private final IModelRegistry modelRegistry_;
    private Map<String, Cookie> cookieMap_;
    private Map<String, String> pathMap_;
    private List<String> errors_ = new LinkedList<String>();

    public RequestContext(HttpMethod method, HttpServletRequest request, HttpServletResponse response, ITraceContext trace, IModelRegistry modelRegistry) {
        this.method_ = method;
        this.request_ = request;
        this.response_ = response;
        this.trace_ = trace;
        this.modelRegistry_ = modelRegistry;
    }

    public HttpMethod getMethod() {
        return this.method_;
    }

    public HttpServletRequest getRequest() {
        return this.request_;
    }

    public HttpServletResponse getResponse() {
        return this.response_;
    }

    public ITraceContext getTrace() {
        return this.trace_;
    }

    @Nullable
    public Boolean getParameterAsBoolean(String name, ParameterLocation location, boolean required) {
        return this.asBoolean(name, this.getParameterAsString(name, location, required));
    }

    @Nullable
    public Long getParameterAsLong(String name, ParameterLocation location, boolean required) {
        return this.asLong(name, this.getParameterAsString(name, location, required));
    }

    public Integer getParameterAsInteger(String name, ParameterLocation location, boolean required) {
        return this.asInteger(name, this.getParameterAsString(name, location, required));
    }

    public ByteString getParameterAsByteString(String name, ParameterLocation location, boolean required) {
        return this.asByteString(name, this.getParameterAsString(name, location, required));
    }

    public ImmutableByteArray getParameterAsImmutableByteArray(String name, ParameterLocation location, boolean required) {
        return this.asImmutableByteArray(name, this.getParameterAsString(name, location, required));
    }

    @Nullable
    public Boolean asBoolean(String parameterName, String value) {
        if (value == null) {
            return null;
        }
        try {
            return Boolean.parseBoolean(value);
        }
        catch (NumberFormatException e) {
            this.error("Parameter %s requires a Boolean value but we found \"%s\"", parameterName, value);
            return null;
        }
    }

    @Nullable
    public Long asLong(String parameterName, String value) {
        if (value == null) {
            return null;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            this.error("Parameter %s requires a Long value but we found \"%s\"", parameterName, value);
            return null;
        }
    }

    @Nullable
    public Integer asInteger(String parameterName, String value) {
        if (value == null) {
            return null;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            this.error("Parameter %s requires an Integer value but we found \"%s\"", value);
            return null;
        }
    }

    @Nullable
    public ByteString asByteString(String parameterName, String value) {
        if (value == null) {
            return null;
        }
        if (!Base64.isBase64((String)value)) {
            this.error("Parameter %s requires a Base64 value but we found \"%s\"", parameterName, value);
            return null;
        }
        return ByteString.copyFrom((byte[])Base64.decodeBase64((String)value));
    }

    @Nullable
    public ImmutableByteArray asImmutableByteArray(String parameterName, String value) {
        if (value == null) {
            return null;
        }
        if (!Base64.isBase64((String)value)) {
            this.error("Parameter %s requires a Base64 value but we found \"%s\"", parameterName, value);
            return null;
        }
        return ImmutableByteArray.newInstance((byte[][])new byte[][]{Base64.decodeBase64((String)value)});
    }

    public String getParameterAsString(String name, ParameterLocation location, boolean required) {
        String value = null;
        switch (location) {
            case Cookie: {
                if (this.cookieMap_ == null) {
                    this.cookieMap_ = new HashMap<String, Cookie>();
                    for (Cookie cookie : this.request_.getCookies()) {
                        this.cookieMap_.put(cookie.getName(), cookie);
                    }
                }
                value = this.cookieMap_.get(name).getValue();
                break;
            }
            case Header: {
                value = this.request_.getHeader(name);
                break;
            }
            case Path: {
                if (this.pathMap_ != null) break;
                this.pathMap_ = new HashMap<String, String>();
                String pathInfo = this.request_.getPathInfo();
                if (pathInfo != null) {
                    String[] parts = pathInfo.split("/");
                    int i = 1;
                    while (parts.length > i) {
                        this.pathMap_.put(parts[i++], parts[i++]);
                    }
                }
                value = this.pathMap_.get(name);
                break;
            }
            case Query: {
                value = this.request_.getParameter(name);
            }
        }
        if (value == null && required) {
            this.errors_.add(String.format("Required %s parameter \"%s\" is missing", new Object[]{location, name}));
        }
        return value;
    }

    public boolean preConditionsAreMet() {
        if (this.errors_.isEmpty()) {
            return true;
        }
        this.sendErrorResponse(400);
        return false;
    }

    public void sendOKResponse() {
        this.response_.setStatus(200);
    }

    public void sendOKResponse(IBaseEntity response) throws IOException {
        this.response_.setStatus(200);
        this.response_.getWriter().println(response.serialize());
    }

    public void sendOKResponse(List<? extends IBaseEntity> response) throws IOException {
        this.response_.setStatus(200);
        PrintWriter out = this.response_.getWriter();
        boolean first = true;
        out.print("[");
        for (IBaseEntity iBaseEntity : response) {
            if (first) {
                first = false;
            } else {
                out.println(",");
            }
            out.print("  ");
            out.print(iBaseEntity.serialize());
        }
        if (!first) {
            out.println();
        }
        out.println("]");
    }

    public void sendErrorResponse(int statusCode) {
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode arrayNode = mapper.createArrayNode();
        for (String error : this.errors_) {
            arrayNode.add(error);
        }
        try {
            this.response_.setContentType(JSON_CONTENT_TYPE);
            this.response_.setStatus(statusCode);
            this.response_.getWriter().println(arrayNode.toString());
        }
        catch (IOException e) {
            log_.error("Failed to send error response", (Throwable)e);
        }
    }

    public void error(String format, Object ... args) {
        this.errors_.add(String.format(format, args));
    }

    public void error(Throwable t) {
        String message = t.getMessage();
        if (message == null) {
            message = t.toString();
        }
        this.errors_.add(String.format(message, new Object[0]));
    }

    public <E extends IEntity> E parsePayload(String typeId, Class<E> type) {
        try {
            return this.modelRegistry_.parseOne(this.getRequest().getReader(), typeId, type);
        }
        catch (IOException | RuntimeException e) {
            log_.error("Failed to parse payload", (Throwable)e);
            this.error("Unable to parse payload", new Object[0]);
            String message = e.getMessage();
            if (message != null) {
                this.error(message, new Object[0]);
            }
            return null;
        }
    }

    public <M, T> M parsePayload(TypeDefBuilder<M, T> builder) {
        try {
            JsonValue<?, ?> jsonObject = ModelRegistry.parseOneJsonValue(this.getRequest().getReader());
            return builder.build(jsonObject);
        }
        catch (IOException | IllegalArgumentException e) {
            log_.error("Failed to parse payload", (Throwable)e);
            this.error("Unable to parse payload", new Object[0]);
            String message = e.getMessage();
            if (message != null) {
                this.error(message, new Object[0]);
            }
            return null;
        }
    }

    public <E extends IEntity> List<E> parseListPayload(Class<E> type) {
        LinkedList<IEntity> result;
        block4: {
            result = new LinkedList<IEntity>();
            try {
                for (ImmutableJsonObject jsonObject : ModelRegistry.parseListOfJsonObjects(this.getRequest().getReader())) {
                    IEntity entity = this.modelRegistry_.newInstance(jsonObject);
                    if (type.isInstance(entity)) {
                        result.add((IEntity)type.cast(entity));
                        continue;
                    }
                    throw new BadRequestException("Found a list item of invalid type " + entity.getClass().getName());
                }
            }
            catch (IOException | IllegalArgumentException e) {
                log_.error("Failed to parse payload", (Throwable)e);
                this.error("Unable to parse payload", new Object[0]);
                String message = e.getMessage();
                if (message == null) break block4;
                this.error(message, new Object[0]);
            }
        }
        return result;
    }

    public <M, T> List<M> parseListPayload(TypeDefBuilder<M, T> builder) {
        LinkedList<M> result;
        block3: {
            result = new LinkedList<M>();
            try {
                for (JsonValue<?, ?> jsonObject : ModelRegistry.parseListOfJsonValues(this.getRequest().getReader())) {
                    result.add(builder.build(jsonObject));
                }
            }
            catch (IOException | IllegalArgumentException e) {
                log_.error("Failed to parse payload", (Throwable)e);
                this.error("Unable to parse payload", new Object[0]);
                String message = e.getMessage();
                if (message == null) break block3;
                this.error(message, new Object[0]);
            }
        }
        return result;
    }
}

