/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.canon.runtime;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.symphonyoss.s2.canon.runtime.Entity;
import org.symphonyoss.s2.canon.runtime.IEntity;
import org.symphonyoss.s2.canon.runtime.IEntityConsumer;
import org.symphonyoss.s2.canon.runtime.IEntityFactory;
import org.symphonyoss.s2.canon.runtime.IModelRegistry;
import org.symphonyoss.s2.canon.runtime.JsonArrayParser;
import org.symphonyoss.s2.common.dom.json.IJsonDomNode;
import org.symphonyoss.s2.common.dom.json.IJsonObject;
import org.symphonyoss.s2.common.dom.json.ImmutableJsonObject;
import org.symphonyoss.s2.common.dom.json.JsonValue;
import org.symphonyoss.s2.common.dom.json.jackson.JacksonAdaptor;

public class ModelRegistry
implements IModelRegistry {
    private Map<String, IEntityFactory<?, ?, ?>> factoryMap_ = new HashMap();

    public ModelRegistry withFactories(IEntityFactory<?, ?, ?> ... factories) {
        for (IEntityFactory<?, ?, ?> factory : factories) {
            this.factoryMap_.put(factory.getCanonType(), factory);
        }
        return this;
    }

    @Override
    public IEntity newInstance(ImmutableJsonObject jsonObject) {
        return this.newInstance(jsonObject, null);
    }

    @Override
    public IEntity newInstance(ImmutableJsonObject jsonObject, @Nullable String expectedTypeId) {
        IEntityFactory<?, ?, ?> factory;
        String typeId = jsonObject.getString("_type", null);
        if (expectedTypeId == null) {
            if (typeId == null) {
                return new Entity(jsonObject);
            }
        } else if (typeId == null) {
            typeId = expectedTypeId;
        } else if (!expectedTypeId.equals(typeId)) {
            throw new IllegalArgumentException("Expected instance of " + expectedTypeId + " but found a " + typeId);
        }
        if ((factory = this.factoryMap_.get(typeId)) == null) {
            return new Entity(jsonObject);
        }
        return factory.newInstance(jsonObject, this);
    }

    @Override
    public <E extends IEntity> E parseOne(Reader reader, String defaultTypeId, Class<E> type) {
        return this.newInstance(ModelRegistry.parseOneJsonObject(reader), defaultTypeId, type);
    }

    @Override
    public <E extends IEntity> E newInstance(ImmutableJsonObject jsonObject, String defaultTypeId, Class<E> type) {
        String typeId;
        if (defaultTypeId == null) {
            typeId = jsonObject.getRequiredString("_type");
        } else {
            typeId = jsonObject.getString("_type", null);
            if (typeId == null) {
                typeId = defaultTypeId;
            }
        }
        IEntityFactory<?, ?, ?> factory = this.factoryMap_.get(typeId);
        if (factory == null && (factory = this.factoryMap_.get(defaultTypeId)) == null) {
            throw new IllegalArgumentException("Unknown type \"" + typeId + "\"");
        }
        Object result = factory.newInstance(jsonObject, this);
        if (type.isInstance(result)) {
            return (E)((IEntity)type.cast(result));
        }
        throw new IllegalArgumentException("Expected instance of " + type + " but found a " + typeId);
    }

    public static List<ImmutableJsonObject> parseListOfJsonObjects(Reader reader) {
        LinkedList<ImmutableJsonObject> result;
        block5: {
            result = new LinkedList<ImmutableJsonObject>();
            ObjectMapper mapper = new ObjectMapper().configure(JsonParser.Feature.AUTO_CLOSE_SOURCE, false);
            try {
                JsonNode tree = mapper.readTree(reader);
                if (tree.isArray()) {
                    for (JsonNode node : tree) {
                        IJsonDomNode adapted = JacksonAdaptor.adapt((JsonNode)node);
                        if (adapted instanceof IJsonObject) {
                            result.add((ImmutableJsonObject)adapted.immutify());
                            continue;
                        }
                        throw new IllegalArgumentException("Expected an array of JSON objects but read a " + tree.getClass().getName());
                    }
                    break block5;
                }
                throw new IllegalArgumentException("Expected a JSON array but read a " + tree.getClass().getName());
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Failed to parse input", e);
            }
        }
        return result;
    }

    public static ImmutableJsonObject parseOneJsonObject(Reader reader) {
        ObjectMapper mapper = new ObjectMapper().configure(JsonParser.Feature.AUTO_CLOSE_SOURCE, false);
        try {
            JsonNode tree = mapper.readTree(reader);
            IJsonDomNode adapted = JacksonAdaptor.adapt((JsonNode)tree);
            if (adapted instanceof IJsonObject) {
                return (ImmutableJsonObject)adapted.immutify();
            }
            throw new IllegalArgumentException("Expected a JSON Object but read a " + adapted.getClass().getName());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to parse input", e);
        }
    }

    public static List<JsonValue<?, ?>> parseListOfJsonValues(Reader reader) {
        LinkedList result;
        block5: {
            result = new LinkedList();
            ObjectMapper mapper = new ObjectMapper().configure(JsonParser.Feature.AUTO_CLOSE_SOURCE, false);
            try {
                JsonNode tree = mapper.readTree(reader);
                if (tree.isArray()) {
                    for (JsonNode node : tree) {
                        if (node.isValueNode()) {
                            result.add((JsonValue)JacksonAdaptor.adapt((JsonNode)node));
                            continue;
                        }
                        throw new IllegalArgumentException("Expected an array of JSON values but read a " + tree.getClass().getName());
                    }
                    break block5;
                }
                throw new IllegalArgumentException("Expected a JSON array but read a " + tree.getClass().getName());
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Failed to parse input", e);
            }
        }
        return result;
    }

    public static JsonValue<?, ?> parseOneJsonValue(Reader reader) {
        ObjectMapper mapper = new ObjectMapper().configure(JsonParser.Feature.AUTO_CLOSE_SOURCE, false);
        try {
            JsonNode tree = mapper.readTree(reader);
            if (tree.isValueNode()) {
                return (JsonValue)JacksonAdaptor.adapt((JsonNode)tree);
            }
            throw new IllegalArgumentException("Expected a JSON value but read a " + tree.getClass().getName());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to parse input", e);
        }
    }

    @Override
    public IEntity parseOne(Reader reader) {
        return this.parseOne(reader, null);
    }

    @Override
    public IEntity parseOne(Reader reader, @Nullable String typeId) {
        return this.newInstance(ModelRegistry.parseOneJsonObject(reader), typeId);
    }

    @Override
    public void parseStream(InputStream in, final IEntityConsumer consumer) {
        byte[] buf = new byte[1024];
        try (JsonArrayParser arrayParser = new JsonArrayParser(){

            @Override
            protected void handle(String input) {
                IEntity result = ModelRegistry.this.parseOne(new StringReader(input));
                consumer.consume(result);
            }
        };){
            int nbytes;
            while ((nbytes = in.read(buf)) != -1) {
                arrayParser.process(buf, nbytes);
            }
        }
    }
}

