/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.canon.runtime.http.client;

import com.google.protobuf.ByteString;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.symphonyoss.s2.canon.runtime.exception.BadRequestException;
import org.symphonyoss.s2.canon.runtime.exception.NotFoundException;
import org.symphonyoss.s2.canon.runtime.exception.PermissionDeniedException;
import org.symphonyoss.s2.canon.runtime.exception.ServerErrorException;
import org.symphonyoss.s2.canon.runtime.http.client.HttpModelClient;
import org.symphonyoss.s2.common.immutable.ImmutableByteArray;

public class HttpRequestOrBuilder<MC extends HttpModelClient> {
    private final MC canonClient_;

    public HttpRequestOrBuilder(MC canonClient) {
        this.canonClient_ = canonClient;
    }

    public MC getCanonClient() {
        return this.canonClient_;
    }

    public String asString(ByteString byteString) {
        return Base64.encodeBase64URLSafeString((byte[])byteString.toByteArray());
    }

    public String asString(ImmutableByteArray byteString) {
        return byteString.toBase64UrlSafeString();
    }

    public String asString(Number number) {
        return number.toString();
    }

    public String asString(Boolean v) {
        return v.toString();
    }

    public String asString(String s) {
        return s;
    }

    public void validateResponse(CloseableHttpResponse response) throws PermissionDeniedException, BadRequestException, ServerErrorException {
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode == 403) {
            throw new PermissionDeniedException(response);
        }
        if (statusCode == 404) {
            throw new NotFoundException(response);
        }
        if (statusCode < 200 || statusCode > 599) {
            throw new ServerErrorException(statusCode, "Unexpected HTTP response", response);
        }
        if (statusCode >= 300 && statusCode <= 399) {
            throw new ServerErrorException(statusCode, "Unexpected HTTP response", response);
        }
        if (statusCode >= 500) {
            throw new ServerErrorException(statusCode, response);
        }
        if (statusCode >= 400) {
            throw new BadRequestException(response);
        }
    }
}

