/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.canon.runtime;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.symphonyoss.s2.canon.runtime.IAbstractEntityHandler;
import org.symphonyoss.s2.canon.runtime.exception.CanonException;
import org.symphonyoss.s2.canon.runtime.exception.NotFoundException;
import org.symphonyoss.s2.canon.runtime.exception.ServerErrorException;
import org.symphonyoss.s2.canon.runtime.http.IRequestAuthenticator;
import org.symphonyoss.s2.canon.runtime.http.IRequestContext;

public abstract class AbstractPathHandler<T, C extends IRequestContext>
implements IAbstractEntityHandler {
    private static final Logger log_ = LoggerFactory.getLogger(AbstractPathHandler.class);
    private final IRequestAuthenticator<T> authenticator_;
    private final int variableCnt_;
    private final String[] parts_;
    private final int partsLength_;

    public AbstractPathHandler(@Nullable IRequestAuthenticator<T> authenticator, int variableCnt, String[] parts) {
        this.authenticator_ = authenticator;
        this.parts_ = parts;
        this.variableCnt_ = variableCnt;
        int cnt = 0;
        for (String s : this.parts_) {
            cnt += s.length();
        }
        this.partsLength_ = cnt;
    }

    public boolean handle(C context) throws IOException {
        List<String> variables = this.getVariablesIfCanHandle(context.getPathInfo());
        if (variables == null) {
            return false;
        }
        try {
            this.handle(this.authenticator_ == null ? null : (T)this.authenticator_.authenticate((IRequestContext)context), context, variables);
        }
        catch (ServerErrorException e) {
            log_.error("Failed to service REST request", (Throwable)e);
            context.error(e);
            context.sendErrorResponse(e.getHttpStatusCode());
        }
        catch (NotFoundException e) {
            context.error(e);
            context.sendErrorResponse(e.getHttpStatusCode());
        }
        catch (CanonException e) {
            log_.info("Failed to service REST request", (Throwable)e);
            context.error(e);
            context.sendErrorResponse(e.getHttpStatusCode());
        }
        catch (RuntimeException e) {
            log_.info("Failed to service REST request", (Throwable)e);
            context.error(e);
            context.sendErrorResponse(500);
        }
        return true;
    }

    @Nullable
    List<String> getVariablesIfCanHandle(String path) {
        if (path == null || path.length() < 2) {
            return null;
        }
        int part = 0;
        int partIndex = 0;
        ArrayList<String> variables = new ArrayList<String>();
        StringBuilder var = null;
        for (int i = 0; i < path.length(); ++i) {
            if (var == null) {
                if (partIndex >= this.parts_[part].length()) {
                    var = new StringBuilder();
                    var.append(path.charAt(i));
                    ++part;
                    partIndex = 1;
                    continue;
                }
                if (path.charAt(i) == this.parts_[part].charAt(partIndex)) {
                    ++partIndex;
                    continue;
                }
                return null;
            }
            if (path.charAt(i) == '/') {
                variables.add(var.toString());
                var = null;
                if (part < this.parts_.length) continue;
                return null;
            }
            var.append(path.charAt(i));
        }
        if (this.parts_.length > part && partIndex >= this.parts_[part].length()) {
            ++part;
            partIndex = 0;
        }
        if (part < this.parts_.length) {
            return null;
        }
        if (var != null) {
            variables.add(var.toString());
        }
        if (variables.size() != this.variableCnt_) {
            return null;
        }
        return variables;
    }

    @Override
    public int getPartsLength() {
        return this.partsLength_;
    }

    protected abstract void handle(T var1, C var2, List<String> var3) throws IOException, CanonException;

    public void unsupportedMethod(T canonAuth, IRequestContext context) throws IOException {
        context.sendError(405, "Method \"" + (Object)((Object)context.getMethod()) + "\" is not supported.");
    }
}

