/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.canon.runtime;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.symphonyoss.s2.canon.runtime.IAbstractEntityHandler;
import org.symphonyoss.s2.canon.runtime.IAsyncEntityHandler;
import org.symphonyoss.s2.canon.runtime.IEntityHandler;
import org.symphonyoss.s2.canon.runtime.IModelRegistry;
import org.symphonyoss.s2.canon.runtime.IModelServlet;
import org.symphonyoss.s2.canon.runtime.http.HttpMethod;
import org.symphonyoss.s2.canon.runtime.http.ServletRequestContext;
import org.symphonyoss.s2.fugue.core.trace.ITraceContext;
import org.symphonyoss.s2.fugue.core.trace.ITraceContextTransaction;
import org.symphonyoss.s2.fugue.core.trace.ITraceContextTransactionFactory;

public class ModelServlet
extends HttpServlet
implements IModelServlet {
    private static final long serialVersionUID = 1L;
    private final ITraceContextTransactionFactory traceFactory_;
    private final IModelRegistry modelRegistry_;
    private final TreeMap<Integer, List<IAbstractEntityHandler>> handlerMap_ = new TreeMap(new Comparator<Integer>(){

        @Override
        public int compare(Integer a, Integer b) {
            if (a > b) {
                return -1;
            }
            if (a < b) {
                return 1;
            }
            return 0;
        }
    });

    public ModelServlet(ITraceContextTransactionFactory traceFactory, IModelRegistry modelRegistry) {
        this.traceFactory_ = traceFactory;
        this.modelRegistry_ = modelRegistry;
    }

    public String getUrlPath() {
        return "/*";
    }

    @Override
    public ModelServlet withHandler(IEntityHandler handler) {
        return this.addHandler(handler);
    }

    @Override
    public ModelServlet withHandler(IAsyncEntityHandler handler) {
        return this.addHandler(handler);
    }

    private ModelServlet addHandler(IAbstractEntityHandler handler) {
        List<IAbstractEntityHandler> list = this.handlerMap_.get(handler.getPartsLength());
        if (list == null) {
            list = new ArrayList<IAbstractEntityHandler>();
            this.handlerMap_.put(handler.getPartsLength(), list);
        }
        list.add(handler);
        return this;
    }

    private void handle(HttpMethod method, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try (ITraceContextTransaction traceTransaction = this.traceFactory_.createTransaction("HTTP " + (Object)((Object)method), UUID.randomUUID().toString());){
            ITraceContext trace = traceTransaction.open();
            ServletRequestContext context = new ServletRequestContext(method, trace, this.modelRegistry_, req, resp);
            for (List<IAbstractEntityHandler> list : this.handlerMap_.values()) {
                for (IAbstractEntityHandler handler : list) {
                    if (!this.handle(handler, context)) continue;
                    traceTransaction.finished();
                    return;
                }
            }
            context.error("No handler found for " + context.getPathInfo());
            context.sendErrorResponse(404);
            traceTransaction.aborted();
        }
    }

    private boolean handle(IAbstractEntityHandler handler, ServletRequestContext context) throws IOException {
        if (handler instanceof IEntityHandler) {
            return ((IEntityHandler)handler).handle(context);
        }
        return ((IAsyncEntityHandler)handler).handle(context);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handle(HttpMethod.Get, req, resp);
    }

    protected long getLastModified(HttpServletRequest req) {
        return super.getLastModified(req);
    }

    protected void doHead(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doHead(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handle(HttpMethod.Post, req, resp);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handle(HttpMethod.Put, req, resp);
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handle(HttpMethod.Delete, req, resp);
    }
}

