/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.canon.runtime;

import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.symphonyoss.s2.canon.runtime.IProducerImpl;
import org.symphonyoss.s2.common.fault.TransactionFault;
import org.symphonyoss.s2.fugue.core.trace.ITraceContext;
import org.symphonyoss.s2.fugue.pipeline.IConsumer;

public class SynchronousProducer<V>
implements IProducerImpl<V> {
    private static Logger log_ = LoggerFactory.getLogger(SynchronousProducer.class);
    private List<IConsumer<V>> listeners_;

    @Override
    public synchronized void addListener(IConsumer<V> listener) {
        if (this.listeners_ == null) {
            this.listeners_ = new LinkedList<IConsumer<V>>();
        }
        this.listeners_.add(listener);
    }

    @Override
    public synchronized boolean removeListener(IConsumer<V> listener) {
        if (this.listeners_ == null) {
            return false;
        }
        return this.listeners_.remove(listener);
    }

    @Override
    public void produce(V value, ITraceContext trace) {
        if (this.listeners_ != null) {
            for (IConsumer<V> listener : this.listeners_) {
                this.notify(listener, value, trace);
            }
        }
    }

    protected void notify(IConsumer<V> listener, V value, ITraceContext trace) {
        try {
            listener.consume(value, trace);
        }
        catch (TransactionFault e) {
            log_.error("TransactionFault thrown by Monitor listener (removed)", (Throwable)e);
            this.removeListener(listener);
        }
        catch (RuntimeException e) {
            log_.error("Unknown exception thrown by Monitor listener (removed)", (Throwable)e);
            this.removeListener(listener);
        }
    }
}

