/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.canon.runtime;

import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.symphonyoss.s2.canon.runtime.BaseEntity;
import org.symphonyoss.s2.canon.runtime.IEntity;
import org.symphonyoss.s2.canon.runtime.IEntityBuilder;
import org.symphonyoss.s2.canon.runtime.IModelRegistry;
import org.symphonyoss.s2.common.dom.json.IImmutableJsonDomNode;
import org.symphonyoss.s2.common.dom.json.ImmutableJsonObject;

public class Entity
extends BaseEntity
implements IEntity {
    private final ImmutableJsonObject jsonObject_;
    private final String type_;
    private final Integer majorVersion_;
    private final Integer minorVersion_;
    private final ImmutableSet<String> unknownKeys_;

    public Entity(ImmutableJsonObject jsonObject, IModelRegistry modelRegistry) {
        super((IImmutableJsonDomNode)jsonObject);
        this.jsonObject_ = jsonObject;
        HashSet<String> keySet = new HashSet<String>();
        Iterator it = jsonObject.getNameIterator();
        while (it.hasNext()) {
            keySet.add((String)it.next());
        }
        this.type_ = keySet.remove("_type") ? this.jsonObject_.get("_type").toString() : "UNKNONWN";
        if (keySet.remove("_version")) {
            String versionStr = this.jsonObject_.get("_version").toString();
            int i = versionStr.indexOf(46);
            if (i == -1) {
                throw new IllegalArgumentException("Version must be of the form Magor.Minor not \"" + versionStr + "\"");
            }
            try {
                this.majorVersion_ = Integer.parseInt(versionStr.substring(0, i));
                this.minorVersion_ = Integer.parseInt(versionStr.substring(i + 1));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Version must be of the form Magor.Minor not \"" + versionStr + "\"", e);
            }
        } else {
            this.majorVersion_ = null;
            this.minorVersion_ = null;
        }
        this.unknownKeys_ = ImmutableSet.copyOf(keySet);
    }

    public Entity(IEntity canonOther) {
        super((IImmutableJsonDomNode)canonOther.getJsonObject());
        this.jsonObject_ = canonOther.getJsonObject();
        this.type_ = canonOther.getCanonType();
        this.majorVersion_ = canonOther.getCanonMajorVersion();
        this.minorVersion_ = canonOther.getCanonMinorVersion();
        this.unknownKeys_ = canonOther.getCanonUnknownKeys();
    }

    public Entity(IEntityBuilder canonOther) {
        super((IImmutableJsonDomNode)canonOther.getJsonObject());
        this.jsonObject_ = canonOther.getJsonObject();
        this.type_ = canonOther.getCanonType();
        this.majorVersion_ = canonOther.getCanonMajorVersion();
        this.minorVersion_ = canonOther.getCanonMinorVersion();
        this.unknownKeys_ = ImmutableSet.of();
    }

    @Override
    public ImmutableJsonObject getJsonObject() {
        return this.jsonObject_;
    }

    @Override
    @Nonnull
    public String getCanonType() {
        return this.type_;
    }

    @Override
    @Nullable
    public Integer getCanonMajorVersion() {
        return this.majorVersion_;
    }

    @Override
    @Nullable
    public Integer getCanonMinorVersion() {
        return this.minorVersion_;
    }

    @Override
    public ImmutableSet<String> getCanonUnknownKeys() {
        return this.unknownKeys_;
    }
}

