/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.canon.runtime;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.symphonyoss.s2.canon.runtime.IEntity;
import org.symphonyoss.s2.canon.runtime.IEntityBuilder;
import org.symphonyoss.s2.canon.runtime.IEntityFactory;
import org.symphonyoss.s2.canon.runtime.IModelRegistry;
import org.symphonyoss.s2.common.dom.json.IJsonDomNode;
import org.symphonyoss.s2.common.dom.json.ImmutableJsonObject;
import org.symphonyoss.s2.common.dom.json.JsonArray;
import org.symphonyoss.s2.common.dom.json.JsonObject;
import org.symphonyoss.s2.common.dom.json.jackson.JacksonAdaptor;
import org.symphonyoss.s2.common.immutable.ImmutableByteArray;

public abstract class EntityFactory<E extends IEntity, S extends IEntity, B extends IEntityBuilder>
implements IEntityFactory<E, S, B> {
    @Override
    public List<E> newMutableList(JsonArray<?> jsonArray, IModelRegistry modelRegistry) {
        LinkedList list = new LinkedList();
        for (IJsonDomNode node : jsonArray) {
            if (node instanceof JsonObject) {
                list.add(this.newInstance((ImmutableJsonObject)node, modelRegistry));
                continue;
            }
            throw new IllegalArgumentException("Expected an array of JSON objectcs, but encountered a " + node.getClass().getName());
        }
        return list;
    }

    @Override
    public Set<E> newMutableSet(JsonArray<?> jsonArray, IModelRegistry modelRegistry) {
        HashSet list = new HashSet();
        for (IJsonDomNode node : jsonArray) {
            if (node instanceof JsonObject) {
                list.add(this.newInstance((ImmutableJsonObject)node.immutify(), modelRegistry));
                continue;
            }
            throw new IllegalArgumentException("Expected an array of JSON objectcs, but encountered a " + node.getClass().getName());
        }
        return list;
    }

    @Override
    public ImmutableList<E> newImmutableList(JsonArray<?> jsonArray, IModelRegistry modelRegistry) {
        return ImmutableList.copyOf(this.newMutableList(jsonArray, modelRegistry));
    }

    @Override
    public ImmutableSet<E> newImmutableSet(JsonArray<?> jsonArray, IModelRegistry modelRegistry) {
        return ImmutableSet.copyOf(this.newMutableSet(jsonArray, modelRegistry));
    }

    public E newInstance(ImmutableByteArray bytes, IModelRegistry modelRegistry) {
        return this.newInstance(JacksonAdaptor.parseObject((ImmutableByteArray)bytes).immutify(), modelRegistry);
    }
}

