/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.canon.runtime.cache;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.symphonyoss.s2.canon.runtime.IProducerImpl;
import org.symphonyoss.s2.canon.runtime.cache.WeakCacheReference;
import org.symphonyoss.s2.fugue.core.trace.ITraceContext;

public class WeakCache<K, V> {
    private Map<K, WeakReference<V>> map_ = new HashMap<K, WeakReference<V>>();
    private ReferenceQueue<V> queue_ = new ReferenceQueue();
    private Thread discardThread_ = new DiscardThread();
    private IProducerImpl<V> producer_;

    public WeakCache() {
        this(null);
    }

    public WeakCache(IProducerImpl<V> producer) {
        this.producer_ = producer;
        this.discardThread_.start();
    }

    public V fetch(K k) {
        Object v;
        WeakReference<V> ref = this.map_.get(k);
        if (ref != null && (v = ref.get()) != null) {
            return (V)v;
        }
        return null;
    }

    public synchronized Collection<V> getAllCached() {
        LinkedList list = new LinkedList();
        for (WeakReference<V> ref : this.map_.values()) {
            Object v = ref.get();
            if (v == null) continue;
            list.add(v);
        }
        return list;
    }

    public synchronized V cache(K key, V value, ITraceContext trace) {
        V existing = this.fetch(key);
        if (existing != null) {
            return existing;
        }
        this.put(key, value, trace);
        return value;
    }

    protected void put(K key, V value, ITraceContext trace) {
        if (trace != null && this.producer_ != null) {
            this.producer_.produce(value, trace);
        }
        this.map_.put(key, new WeakCacheReference<K, V>(key, value, this.queue_));
    }

    class DiscardThread
    extends Thread {
        private DiscardThread() {
            super("WeakCache-Discard");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Reference ref;
                        if (!((ref = WeakCache.this.queue_.remove()) instanceof WeakCacheReference)) {
                            continue;
                        }
                        WeakCache.this.map_.remove(((WeakCacheReference)ref).getKey());
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }
}

