/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.canon.runtime.exception;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nullable;
import org.apache.http.Header;
import org.apache.http.client.methods.CloseableHttpResponse;

public class CanonException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final int httpStatusCode_;
    private String responseBody_;
    private Header[] responseHeaders_;

    public CanonException(int httpStatusCode) {
        this.httpStatusCode_ = httpStatusCode;
    }

    public CanonException(int httpStatusCode, String message) {
        super(message);
        this.httpStatusCode_ = httpStatusCode;
    }

    public CanonException(int httpStatusCode, String message, Throwable cause) {
        super(message, cause);
        this.httpStatusCode_ = httpStatusCode;
    }

    public CanonException(int httpStatusCode, Throwable cause) {
        super(cause);
        this.httpStatusCode_ = httpStatusCode;
    }

    protected CanonException(int httpStatusCode, String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
        super(message, cause, enableSuppression, writableStackTrace);
        this.httpStatusCode_ = httpStatusCode;
    }

    public CanonException(int httpStatusCode, @Nullable String message, CloseableHttpResponse response) {
        this(httpStatusCode, message, CanonException.getBody(response), response);
    }

    private static String getBody(CloseableHttpResponse response) {
        String string;
        block9: {
            InputStream in = response.getEntity().getContent();
            try {
                int nbytes;
                byte[] buf = new byte[1024];
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                while ((nbytes = in.read(buf)) > 0) {
                    bout.write(buf, 0, nbytes);
                }
                string = bout.toString();
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return "Unable to read response body: " + e.toString();
                }
            }
            in.close();
        }
        return string;
    }

    public CanonException(int httpStatusCode, String message, String responseBody, CloseableHttpResponse response) {
        super(message == null ? response.getStatusLine().toString() + " " + responseBody : message + " " + response.getStatusLine() + " " + responseBody);
        this.responseBody_ = responseBody;
        this.httpStatusCode_ = httpStatusCode;
        this.responseHeaders_ = response.getAllHeaders();
    }

    public int getHttpStatusCode() {
        return this.httpStatusCode_;
    }

    @Nullable
    public String getResponseBody() {
        return this.responseBody_;
    }

    @Nullable
    public Header[] getResponseHeaders() {
        return this.responseHeaders_;
    }
}

