/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.canon.runtime.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.symphonyoss.s2.canon.runtime.IBaseEntity;
import org.symphonyoss.s2.canon.runtime.IEntity;
import org.symphonyoss.s2.canon.runtime.IModelRegistry;
import org.symphonyoss.s2.canon.runtime.ModelRegistry;
import org.symphonyoss.s2.canon.runtime.TypeDefBuilder;
import org.symphonyoss.s2.canon.runtime.exception.BadRequestException;
import org.symphonyoss.s2.canon.runtime.http.HttpMethod;
import org.symphonyoss.s2.canon.runtime.http.IRequestContext;
import org.symphonyoss.s2.canon.runtime.http.ParameterLocation;
import org.symphonyoss.s2.common.dom.json.ImmutableJsonObject;
import org.symphonyoss.s2.common.dom.json.JsonValue;
import org.symphonyoss.s2.common.immutable.ImmutableByteArray;
import org.symphonyoss.s2.common.type.provider.IValueProvider;
import org.symphonyoss.s2.common.type.provider.IValueProviderBuilder;
import org.symphonyoss.s2.fugue.core.trace.ITraceContext;

public abstract class AbstractRequestContext
implements IRequestContext {
    private static Logger log_ = LoggerFactory.getLogger(AbstractRequestContext.class);
    private final HttpMethod method_;
    private final ITraceContext trace_;
    private final IModelRegistry modelRegistry_;
    private Map<String, String> pathMap_;
    private List<String> errors_ = new LinkedList<String>();

    public AbstractRequestContext(HttpMethod method, ITraceContext trace, IModelRegistry modelRegistry) {
        this.method_ = method;
        this.trace_ = trace;
        this.modelRegistry_ = modelRegistry;
    }

    @Override
    public HttpMethod getMethod() {
        return this.method_;
    }

    @Override
    public ITraceContext getTrace() {
        return this.trace_;
    }

    @Override
    @Nullable
    public Boolean getParameterAsBoolean(String name, ParameterLocation location, boolean required) {
        return this.asBoolean(name, this.getParameterAsString(name, location, required));
    }

    @Override
    @Nullable
    public Long getParameterAsLong(String name, ParameterLocation location, boolean required) {
        return this.asLong(name, this.getParameterAsString(name, location, required));
    }

    @Override
    public Integer getParameterAsInteger(String name, ParameterLocation location, boolean required) {
        return this.asInteger(name, this.getParameterAsString(name, location, required));
    }

    @Override
    public ImmutableByteArray getParameterAsImmutableByteArray(String name, ParameterLocation location, boolean required) {
        return this.asImmutableByteArray(name, this.getParameterAsString(name, location, required));
    }

    @Override
    @Nullable
    public String asString(String parameterName, String value) {
        return value;
    }

    @Override
    @Nullable
    public Boolean asBoolean(String parameterName, String value) {
        if (value == null) {
            return null;
        }
        try {
            return Boolean.parseBoolean(value);
        }
        catch (NumberFormatException e) {
            this.error("Parameter %s requires a Boolean value but we found \"%s\"", parameterName, value);
            return null;
        }
    }

    @Override
    @Nullable
    public Long asLong(String parameterName, String value) {
        if (value == null) {
            return null;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            this.error("Parameter %s requires a Long value but we found \"%s\"", parameterName, value);
            return null;
        }
    }

    @Override
    @Nullable
    public Integer asInteger(String parameterName, String value) {
        if (value == null) {
            return null;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            this.error("Parameter %s requires an Integer value but we found \"%s\"", value);
            return null;
        }
    }

    @Override
    @Nullable
    public ImmutableByteArray asImmutableByteArray(String parameterName, String value) {
        if (value == null) {
            return null;
        }
        if (!Base64.isBase64((String)value)) {
            this.error("Parameter %s requires a Base64 value but we found \"%s\"", parameterName, value);
            return null;
        }
        return ImmutableByteArray.newInstance((byte[][])new byte[][]{Base64.decodeBase64((String)value)});
    }

    protected abstract String getCookie(String var1);

    protected abstract String getHeader(String var1);

    protected abstract String getParameter(String var1);

    @Override
    public String getParameterAsString(String name, ParameterLocation location, boolean required) {
        String value = null;
        switch (location) {
            case Cookie: {
                value = this.getCookie(name);
                break;
            }
            case Header: {
                value = this.getHeader(name);
                break;
            }
            case Path: {
                if (this.pathMap_ != null) break;
                this.pathMap_ = new HashMap<String, String>();
                String pathInfo = this.getPathInfo();
                if (pathInfo != null) {
                    String[] parts = pathInfo.split("/");
                    int i = 1;
                    while (parts.length > i) {
                        this.pathMap_.put(parts[i++], parts[i++]);
                    }
                }
                value = this.pathMap_.get(name);
                break;
            }
            case Query: {
                value = this.getParameter(name);
            }
        }
        if (value == null && required) {
            this.errors_.add(String.format("Required %s parameter \"%s\" is missing", new Object[]{location, name}));
        }
        return value;
    }

    @Override
    public boolean preConditionsAreMet() {
        if (this.errors_.isEmpty()) {
            return true;
        }
        this.sendErrorResponse(400);
        return false;
    }

    @Override
    public void sendOKResponse() {
        this.setStatus(200);
    }

    @Override
    public void sendOKResponse(IBaseEntity response) throws IOException {
        this.setStatus(200);
        this.getWriter().println(response.serialize());
    }

    @Override
    public void sendOKResponse(List<? extends IBaseEntity> response) throws IOException {
        this.setStatus(200);
        PrintWriter out = this.getWriter();
        boolean first = true;
        out.print("[");
        for (IBaseEntity iBaseEntity : response) {
            if (first) {
                first = false;
            } else {
                out.println(",");
            }
            out.print("  ");
            out.print(iBaseEntity.serialize());
        }
        if (!first) {
            out.println();
        }
        out.println("]");
    }

    @Override
    public void sendErrorResponse(int statusCode) {
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode arrayNode = mapper.createArrayNode();
        for (String error : this.errors_) {
            arrayNode.add(error);
        }
        try {
            this.setContentType("application/json; charset=utf-8");
            this.setStatus(statusCode);
            this.getWriter().println(arrayNode.toString());
        }
        catch (IOException e) {
            log_.error("Failed to send error response", (Throwable)e);
        }
    }

    @Override
    public void error(String message) {
        this.errors_.add(message);
    }

    @Override
    public void error(String format, Object ... args) {
        this.errors_.add(String.format(format, args));
    }

    @Override
    public void error(Throwable t) {
        String message = t.getMessage();
        if (message == null) {
            message = t.toString();
        }
        this.errors_.add(String.format(message, new Object[0]));
    }

    @Override
    public <E extends IEntity> E parsePayload(String typeId, Class<E> type) {
        try {
            return this.modelRegistry_.parseOne(this.getReader(), typeId, type);
        }
        catch (IOException | RuntimeException e) {
            log_.error("Failed to parse payload", (Throwable)e);
            this.error("Unable to parse payload");
            String message = e.getMessage();
            if (message != null) {
                this.error(message);
            }
            return null;
        }
    }

    @Override
    public <M, T> M parsePayload(TypeDefBuilder<M, T> builder) {
        try {
            JsonValue<?, ?> jsonObject = ModelRegistry.parseOneJsonValue(this.getReader());
            return builder.build((IValueProvider)jsonObject);
        }
        catch (IOException | IllegalArgumentException e) {
            log_.error("Failed to parse payload", (Throwable)e);
            this.error("Unable to parse payload");
            String message = e.getMessage();
            if (message != null) {
                this.error(message);
            }
            return null;
        }
    }

    @Override
    public <M> M parsePayload(IValueProviderBuilder<M> builder) {
        try {
            JsonValue<?, ?> jsonObject = ModelRegistry.parseOneJsonValue(this.getReader());
            return (M)builder.build(jsonObject);
        }
        catch (IOException | IllegalArgumentException e) {
            log_.error("Failed to parse payload", (Throwable)e);
            this.error("Unable to parse payload");
            String message = e.getMessage();
            if (message != null) {
                this.error(message);
            }
            return null;
        }
    }

    @Override
    public <E extends IEntity> List<E> parseListPayload(Class<E> type) {
        LinkedList<IEntity> result;
        block4: {
            result = new LinkedList<IEntity>();
            try {
                for (ImmutableJsonObject jsonObject : ModelRegistry.parseListOfJsonObjects(this.getReader())) {
                    IEntity entity = this.modelRegistry_.newInstance(jsonObject);
                    if (type.isInstance(entity)) {
                        result.add((IEntity)type.cast(entity));
                        continue;
                    }
                    throw new BadRequestException("Found a list item of invalid type " + entity.getClass().getName());
                }
            }
            catch (IOException | IllegalArgumentException e) {
                log_.error("Failed to parse payload", (Throwable)e);
                this.error("Unable to parse payload");
                String message = e.getMessage();
                if (message == null) break block4;
                this.error(message);
            }
        }
        return result;
    }

    @Override
    public <M> List<M> parseListPayload(IValueProviderBuilder<M> builder) {
        LinkedList<Object> result;
        block3: {
            result = new LinkedList<Object>();
            try {
                for (JsonValue<?, ?> jsonObject : ModelRegistry.parseListOfJsonValues(this.getReader())) {
                    result.add(builder.build(jsonObject));
                }
            }
            catch (IOException | IllegalArgumentException e) {
                log_.error("Failed to parse payload", (Throwable)e);
                this.error("Unable to parse payload");
                String message = e.getMessage();
                if (message == null) break block3;
                this.error(message);
            }
        }
        return result;
    }
}

